/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class TempTableInsertExpression
extends AbstractRelationalExpressionWithChildren
implements PlannerGraphRewritable {
    @Nonnull
    private final Quantifier.ForEach inner;
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final Value tempTableReferenceValue;
    private final boolean isOwningTempTable;

    private TempTableInsertExpression(@Nonnull Quantifier.ForEach inner, @Nonnull Value tempTableReferenceValue, boolean isOwningTempTable) {
        this.inner = inner;
        this.tempTableReferenceValue = tempTableReferenceValue;
        this.isOwningTempTable = isOwningTempTable;
        Verify.verify(tempTableReferenceValue.getResultType().isRelation());
        Type innerType = ((Type.Relation)tempTableReferenceValue.getResultType()).getInnerType();
        this.resultValue = new QueriedValue(Objects.requireNonNull(innerType));
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.tempTableReferenceValue.getCorrelatedToWithoutChildren();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public TempTableInsertExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Value translatedTableReferenceValue = this.tempTableReferenceValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new TempTableInsertExpression(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.ForEach.class), translatedTableReferenceValue, this.isOwningTempTable);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public Value getTempTableReferenceValue() {
        return this.tempTableReferenceValue;
    }

    @Nonnull
    public TempTableInsertPlan toPlan(@Nonnull Quantifier.Physical physicalInner) {
        Verify.verify(this.inner.getAlias().equals(physicalInner.getAlias()));
        return TempTableInsertPlan.insertPlan(physicalInner, this.tempTableReferenceValue, this.isOwningTempTable);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        TempTableInsertExpression otherInsertExpression = (TempTableInsertExpression)otherExpression;
        return this.tempTableReferenceValue.semanticEquals((Object)otherInsertExpression.tempTableReferenceValue, equivalencesMap);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.tempTableReferenceValue);
    }

    public String toString() {
        return "TempTableInsert(" + String.valueOf(this.tempTableReferenceValue) + ")";
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(!childGraphs.isEmpty());
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.TemporaryDataNodeWithInfo(this.getResultType(), ImmutableList.of(this.tempTableReferenceValue.toString())), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationLogicalOperatorNode(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("TempTableInsert"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Nonnull
    public static TempTableInsertExpression ofConstant(@Nonnull Quantifier.ForEach inner, @Nonnull CorrelationIdentifier constantAlias, @Nonnull String constantId, @Nonnull Type type) {
        return TempTableInsertExpression.ofConstant(inner, constantAlias, constantId, type, true);
    }

    @Nonnull
    public static TempTableInsertExpression ofConstant(@Nonnull Quantifier.ForEach inner, @Nonnull CorrelationIdentifier constantAlias, @Nonnull String constantId, @Nonnull Type type, boolean isOwningTempTable) {
        return new TempTableInsertExpression(inner, ConstantObjectValue.of(constantAlias, constantId, new Type.Relation(type)), isOwningTempTable);
    }

    @Nonnull
    public static TempTableInsertExpression ofCorrelated(@Nonnull Quantifier.ForEach inner, @Nonnull CorrelationIdentifier correlation, @Nonnull Type type) {
        return TempTableInsertExpression.ofCorrelated(inner, correlation, type, true);
    }

    @Nonnull
    public static TempTableInsertExpression ofCorrelated(@Nonnull Quantifier.ForEach inner, @Nonnull CorrelationIdentifier correlation, @Nonnull Type type, boolean isOwningTempTable) {
        return new TempTableInsertExpression(inner, QuantifiedObjectValue.of(correlation, new Type.Relation(type)), isOwningTempTable);
    }
}

