/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TempTableScanExpression
extends AbstractRelationalExpressionWithoutChildren
implements PlannerGraphRewritable {
    @Nonnull
    private final Value tempTableReferenceValue;
    @Nonnull
    private final QueriedValue resultValue;

    private TempTableScanExpression(@Nonnull Value tempTableReferenceValue) {
        this.tempTableReferenceValue = tempTableReferenceValue;
        Type innerType = ((Type.Relation)tempTableReferenceValue.getResultType()).getInnerType();
        this.resultValue = new QueriedValue(Objects.requireNonNull(innerType));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public Value getTempTableReferenceValue() {
        return this.tempTableReferenceValue;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.tempTableReferenceValue.getCorrelatedTo();
    }

    @Override
    @Nonnull
    public TempTableScanExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        Value translatedTableReferenceValue = this.tempTableReferenceValue.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedTableReferenceValue != this.tempTableReferenceValue) {
            return new TempTableScanExpression(translatedTableReferenceValue);
        }
        return this;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        TempTableScanExpression otherTempTableScanExpression = (TempTableScanExpression)otherExpression;
        return this.getTempTableReferenceValue().semanticEquals((Object)otherTempTableScanExpression.getTempTableReferenceValue(), equivalencesMap);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.tempTableReferenceValue);
    }

    public String toString() {
        return "TempTableScan";
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        PlannerGraph.TemporaryDataNodeWithInfo dataNodeWithInfo = new PlannerGraph.TemporaryDataNodeWithInfo(this.getResultType(), ImmutableList.of(this.tempTableReferenceValue.toString()));
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.TEMP_TABLE_SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of()), ImmutableList.of(PlannerGraph.fromNodeAndChildGraphs(dataNodeWithInfo, childGraphs)));
    }

    @Nonnull
    public static TempTableScanExpression ofConstant(@Nonnull CorrelationIdentifier constantAlias, @Nonnull String constantId, @Nonnull Type type) {
        return new TempTableScanExpression(ConstantObjectValue.of(constantAlias, constantId, new Type.Relation(type)));
    }

    @Nonnull
    public static TempTableScanExpression ofCorrelated(@Nonnull CorrelationIdentifier correlation, @Nonnull Type type) {
        return new TempTableScanExpression(QuantifiedObjectValue.of(correlation, new Type.Relation(type)));
    }
}

