/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAbstractDataModificationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class UpdateExpression
extends AbstractRelationalExpressionWithChildren
implements PlannerGraphRewritable {
    private static final String OLD_FIELD_NAME = "old";
    private static final String NEW_FIELD_NAME = "new";
    @Nonnull
    private final Quantifier.ForEach inner;
    @Nonnull
    private final String targetRecordType;
    @Nonnull
    private final Type.Record targetType;
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final Map<FieldValue.FieldPath, Value> transformMap;

    public UpdateExpression(@Nonnull Quantifier.ForEach inner, @Nonnull String targetRecordType, @Nonnull Type.Record targetType, @Nonnull Map<FieldValue.FieldPath, Value> transformMap) {
        this.inner = inner;
        this.targetRecordType = targetRecordType;
        this.targetType = targetType;
        this.resultValue = new QueriedValue(UpdateExpression.computeResultType(inner.getFlowedObjectType(), targetType));
        this.transformMap = ImmutableMap.copyOf(transformMap);
    }

    @Nonnull
    public Type.Record getTargetType() {
        return this.targetType;
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.transformMap.values().stream().flatMap(value -> value.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    @Nonnull
    public UpdateExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        ImmutableMap.Builder<FieldValue.FieldPath, Value> translatedTransformMapBuilder = ImmutableMap.builder();
        for (Map.Entry<FieldValue.FieldPath, Value> entry : this.transformMap.entrySet()) {
            translatedTransformMapBuilder.put(entry.getKey(), entry.getValue().translateCorrelations(translationMap, shouldSimplifyValues));
        }
        return new UpdateExpression(Iterables.getOnlyElement(translatedQuantifiers).narrow(Quantifier.ForEach.class), this.targetRecordType, this.targetType, translatedTransformMapBuilder.build());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public RecordQueryUpdatePlan toPlan(@Nonnull Quantifier.Physical physicalInner) {
        Verify.verify(this.inner.getAlias().equals(physicalInner.getAlias()));
        return RecordQueryUpdatePlan.updatePlan(physicalInner, this.targetRecordType, this.targetType, this.transformMap, UpdateExpression.makeComputationValue(physicalInner, this.targetType));
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        UpdateExpression otherUpdateExpression = (UpdateExpression)otherExpression;
        return this.targetRecordType.equals(otherUpdateExpression.targetRecordType) && this.targetType.equals(otherUpdateExpression.targetType) && UpdateExpression.semanticEqualsForTransformMap(this.transformMap, otherUpdateExpression.transformMap, equivalencesMap);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.targetRecordType, this.targetType, this.transformMap);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Update(");
        str.append(this.targetRecordType).append(", ");
        str.append("[").append(this.transformMap.keySet().stream().map(FieldValue.FieldPath::toString).collect(Collectors.joining(", "))).append("] ");
        return str.toString();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(!childGraphs.isEmpty());
        PlannerGraph graphForTarget = PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of(this.targetRecordType)), ImmutableList.of());
        return PlannerGraph.fromNodeInnerAndTargetForModifications(new PlannerGraph.ModificationLogicalOperatorNode(this, NodeInfo.MODIFICATION_OPERATOR, ImmutableList.of("UPDATE"), ImmutableMap.of()), Iterables.getOnlyElement(childGraphs), graphForTarget);
    }

    @Nonnull
    private static Type.Record computeResultType(@Nonnull Type inType, @Nonnull Type targetType) {
        return Type.Record.fromFields(false, ImmutableList.of(Type.Record.Field.of(inType, Optional.of(OLD_FIELD_NAME)), Type.Record.Field.of(targetType, Optional.of(NEW_FIELD_NAME))));
    }

    @Nonnull
    public static Value makeComputationValue(@Nonnull Quantifier inner, @Nonnull Type targetType) {
        Column<QuantifiedObjectValue> oldColumn = Column.of(Optional.of(OLD_FIELD_NAME), inner.getFlowedObjectValue());
        Column<ObjectValue> newColumn = Column.of(Optional.of(NEW_FIELD_NAME), ObjectValue.of(RecordQueryAbstractDataModificationPlan.currentModifiedRecordAlias(), targetType));
        return RecordConstructorValue.ofColumns(ImmutableList.of(oldColumn, newColumn));
    }

    private static boolean semanticEqualsForTransformMap(@Nonnull Map<FieldValue.FieldPath, Value> self, @Nonnull Map<FieldValue.FieldPath, Value> other, @Nonnull AliasMap equivalencesMap) {
        if (self.size() != other.size()) {
            return false;
        }
        for (Map.Entry<FieldValue.FieldPath, Value> entry : self.entrySet()) {
            Value otherValue;
            FieldValue.FieldPath fieldPath = entry.getKey();
            Value selfValue = entry.getValue();
            if (selfValue.semanticEquals((Object)(otherValue = other.get(fieldPath)), equivalencesMap)) continue;
            return false;
        }
        return true;
    }
}

