/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.combinatorics.ChooseK;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IterableHelpers;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.EnumerationFunction;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class BaseMatcher<T> {
    @Nonnull
    private final AliasMap boundAliasesMap;
    @Nonnull
    private final Set<CorrelationIdentifier> aliases;
    @Nonnull
    private final Function<T, CorrelationIdentifier> elementToAliasFn;
    @Nonnull
    private final Map<CorrelationIdentifier, T> aliasToElementMap;
    @Nonnull
    private final ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap;
    @Nonnull
    private final Set<CorrelationIdentifier> otherAliases;
    @Nonnull
    private final Function<T, CorrelationIdentifier> otherElementToAliasFn;
    @Nonnull
    private final Map<CorrelationIdentifier, ? extends T> otherAliasToElementMap;
    @Nonnull
    private final ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> otherDependsOnMap;

    protected BaseMatcher(@Nonnull AliasMap boundAliasesMap, @Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Map<CorrelationIdentifier, T> aliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<T, CorrelationIdentifier> otherElementToAliasFn, @Nonnull Map<CorrelationIdentifier, ? extends T> otherAliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> otherDependsOnMap) {
        this.boundAliasesMap = boundAliasesMap;
        this.aliases = aliases;
        this.elementToAliasFn = elementToAliasFn;
        this.aliasToElementMap = aliasToElementMap;
        this.dependsOnMap = dependsOnMap;
        this.otherAliases = otherAliases;
        this.otherElementToAliasFn = otherElementToAliasFn;
        this.otherAliasToElementMap = otherAliasToElementMap;
        this.otherDependsOnMap = otherDependsOnMap;
    }

    @Nonnull
    public AliasMap getBoundAliasesMap() {
        return this.boundAliasesMap;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getAliases() {
        return this.aliases;
    }

    @Nonnull
    public Function<T, CorrelationIdentifier> getElementToAliasFn() {
        return this.elementToAliasFn;
    }

    @Nonnull
    public Map<CorrelationIdentifier, T> getAliasToElementMap() {
        return this.aliasToElementMap;
    }

    @Nonnull
    public ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> getDependsOnMap() {
        return this.dependsOnMap;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getOtherAliases() {
        return this.otherAliases;
    }

    @Nonnull
    public Function<T, CorrelationIdentifier> getOtherElementToAliasFn() {
        return this.otherElementToAliasFn;
    }

    @Nonnull
    public Map<CorrelationIdentifier, ? extends T> getOtherAliasToElementMap() {
        return this.otherAliasToElementMap;
    }

    @Nonnull
    public ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> getOtherDependsOnMap() {
        return this.otherDependsOnMap;
    }

    @Nonnull
    protected <R> Iterable<R> match(@Nonnull EnumerationFunction<R> enumerationFunction, boolean isCompleteMatchesOnly) {
        if (isCompleteMatchesOnly && this.getAliases().size() != this.getOtherAliases().size()) {
            return ImmutableList.of();
        }
        Optional<List<CorrelationIdentifier>> otherOrderedOptional = TopologicalSort.anyTopologicalOrderPermutation(this.getOtherAliases(), this.otherDependsOnMap);
        Verify.verify(!isCompleteMatchesOnly || this.aliases.isEmpty() || otherOrderedOptional.isPresent());
        List otherPermutation = otherOrderedOptional.orElse(ImmutableList.of());
        int maxMatchSize = Math.min(this.aliases.size(), otherPermutation.size());
        ImmutableList<Set<CorrelationIdentifier>> otherCombinationsIterable = isCompleteMatchesOnly ? ImmutableList.of(this.getOtherAliases()) : BaseMatcher.soundCombinations(this.getOtherAliases(), this.getOtherDependsOnMap(), 0, maxMatchSize);
        return IterableHelpers.flatMap(otherCombinationsIterable, otherCombination -> {
            List otherFilteredPermutation = otherPermutation.stream().filter(otherCombination::contains).collect(ImmutableList.toImmutableList());
            ImmutableList<Set<CorrelationIdentifier>> combinationsIterable = isCompleteMatchesOnly ? ImmutableList.of(this.getAliases()) : BaseMatcher.soundCombinations(this.getAliases(), this.getDependsOnMap(), otherCombination.size(), otherCombination.size());
            return IterableHelpers.flatMap(combinationsIterable, combination -> {
                EnumeratingIterable<CorrelationIdentifier> permutationsIterable = TopologicalSort.topologicalOrderPermutations(combination, this.dependsOnMap);
                return () -> enumerationFunction.apply((EnumeratingIterator<CorrelationIdentifier>)permutationsIterable.iterator(), otherFilteredPermutation);
            });
        });
    }

    protected boolean isIsomorphic(@Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> dependsOn, @Nonnull Set<CorrelationIdentifier> otherDependsOn) {
        ImmutableSet mappedSet = dependsOn.stream().filter(aliasMap::containsSource).map(dependentAlias -> Objects.requireNonNull(aliasMap.getTarget((CorrelationIdentifier)dependentAlias))).collect(ImmutableSet.toImmutableSet());
        return otherDependsOn.containsAll(mappedSet);
    }

    @Nonnull
    private static Iterable<Set<CorrelationIdentifier>> soundCombinations(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap, int startInclusive, int endInclusive) {
        Preconditions.checkArgument(endInclusive <= aliases.size());
        return () -> IntStream.rangeClosed(startInclusive, endInclusive).boxed().flatMap(k -> {
            Iterator combinationsIterator = ChooseK.chooseK(aliases, k).iterator();
            AbstractIterator<Set<CorrelationIdentifier>> filteredCombinationsIterator = new AbstractIterator<Set<CorrelationIdentifier>>((EnumeratingIterator)combinationsIterator, dependsOnMap){
                final /* synthetic */ EnumeratingIterator val$combinationsIterator;
                final /* synthetic */ ImmutableSetMultimap val$dependsOnMap;
                {
                    this.val$combinationsIterator = enumeratingIterator;
                    this.val$dependsOnMap = immutableSetMultimap;
                }

                @Override
                protected Set<CorrelationIdentifier> computeNext() {
                    while (this.val$combinationsIterator.hasNext()) {
                        int i;
                        List combination = (List)this.val$combinationsIterator.next();
                        ImmutableSet<CorrelationIdentifier> combinationAsSet = ImmutableSet.copyOf(combination);
                        for (i = 0; i < combination.size(); ++i) {
                            CorrelationIdentifier alias = (CorrelationIdentifier)combination.get(i);
                            ImmutableSet outsideDependsOn = this.val$dependsOnMap.get(alias).stream().filter(dependsOnAlias -> !combinationAsSet.contains(dependsOnAlias)).flatMap(dependsOnAlias -> this.val$dependsOnMap.get(dependsOnAlias).stream()).collect(ImmutableSet.toImmutableSet());
                            boolean brokenCombination = outsideDependsOn.stream().anyMatch(combinationAsSet::contains);
                            if (brokenCombination) break;
                        }
                        if (i < combination.size()) {
                            this.val$combinationsIterator.skip(i);
                            continue;
                        }
                        return combinationAsSet;
                    }
                    return (Set)this.endOfData();
                }
            };
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(filteredCombinationsIterator, 16), false);
        }).iterator();
    }

    @Nonnull
    protected Optional<AliasMap> mapDependenciesToOther(@Nonnull AliasMap aliasMap, @Nonnull CorrelationIdentifier alias, @Nonnull CorrelationIdentifier otherAlias) {
        ImmutableCollection otherDependsOn;
        ImmutableCollection dependsOn = this.getDependsOnMap().get((Object)alias);
        if (!this.isIsomorphic(aliasMap, (Set<CorrelationIdentifier>)((Object)dependsOn), (Set<CorrelationIdentifier>)((Object)(otherDependsOn = this.getOtherDependsOnMap().get((Object)otherAlias))))) {
            return Optional.empty();
        }
        return Optional.of(aliasMap.filterMappings((arg_0, arg_1) -> BaseMatcher.lambda$mapDependenciesToOther$6((Set)((Object)dependsOn), arg_0, arg_1)));
    }

    private static /* synthetic */ boolean lambda$mapDependenciesToOther$6(Set dependsOn, CorrelationIdentifier source, CorrelationIdentifier target) {
        return dependsOn.contains(source);
    }
}

