/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.google.common.base.Verify;
import java.util.Optional;
import javax.annotation.Nonnull;

public class BoundMatch<R> {
    @Nonnull
    private final AliasMap aliasMap;
    @Nonnull
    private final Optional<R> matchResultOptional;

    private BoundMatch(@Nonnull AliasMap aliasMap, @Nonnull Optional<R> matchResultOptional) {
        this.aliasMap = aliasMap;
        this.matchResultOptional = matchResultOptional;
    }

    @Nonnull
    public AliasMap getAliasMap() {
        return this.aliasMap;
    }

    @Nonnull
    public Optional<R> getMatchResultOptional() {
        return this.matchResultOptional;
    }

    @Nonnull
    public R getMatchResult() {
        Verify.verify(this.matchResultOptional.isPresent());
        return this.matchResultOptional.get();
    }

    @Nonnull
    public static <R> BoundMatch<R> withAliasMapAndMatchResult(AliasMap aliasMap, @Nonnull R matchResult) {
        return new BoundMatch<R>(aliasMap, Optional.of(matchResult));
    }

    @Nonnull
    public static <R> BoundMatch<R> withAliasMap(AliasMap aliasMap) {
        return new BoundMatch(aliasMap, Optional.empty());
    }
}

