/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.apple.foundationdb.record.query.combinatorics.TransitiveClosure;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BaseMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BoundMatch;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.DependencyUtils;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.GenericMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchAccumulator;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchFunction;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ComputingMatcher<T, M, R>
extends BaseMatcher<T>
implements GenericMatcher<BoundMatch<R>> {
    @Nonnull
    private final MatchFunction<T, M> matchFunction;
    @Nonnull
    private final Supplier<MatchAccumulator<M, R>> matchAccumulatorSupplier;

    private ComputingMatcher(@Nonnull AliasMap boundAliasesMap, @Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Map<CorrelationIdentifier, T> aliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<T, CorrelationIdentifier> otherElementToAliasFn, @Nonnull Map<CorrelationIdentifier, ? extends T> otherAliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> otherDependsOnMap, @Nonnull MatchFunction<T, M> matchFunction, @Nonnull Supplier<MatchAccumulator<M, R>> matchAccumulatorSupplier) {
        super(boundAliasesMap, aliases, elementToAliasFn, aliasToElementMap, dependsOnMap, otherAliases, otherElementToAliasFn, otherAliasToElementMap, otherDependsOnMap);
        this.matchFunction = matchFunction;
        this.matchAccumulatorSupplier = matchAccumulatorSupplier;
    }

    @Override
    @Nonnull
    public Iterable<BoundMatch<R>> match() {
        return this.match(this::enumerate, false);
    }

    @Nonnull
    public Iterator<BoundMatch<R>> enumerate(final @Nonnull EnumeratingIterator<CorrelationIdentifier> iterator, final @Nonnull List<CorrelationIdentifier> otherPermutation) {
        final Set<CorrelationIdentifier> aliases = this.getAliases();
        final AliasMap boundAliasesMap = this.getBoundAliasesMap();
        if (otherPermutation.isEmpty()) {
            return ImmutableList.of(BoundMatch.withAliasMap(boundAliasesMap)).iterator();
        }
        final int size = otherPermutation.size();
        return new AbstractIterator<BoundMatch<R>>(){

            @Override
            protected BoundMatch<R> computeNext() {
                while (iterator.hasNext()) {
                    CorrelationIdentifier otherAlias;
                    CorrelationIdentifier alias;
                    AliasMap aliasMap;
                    Optional<AliasMap> locallyBoundMapOptional;
                    int i;
                    List permutation = (List)iterator.next();
                    AliasMap.Builder aliasMapBuilder = AliasMap.builder(aliases.size());
                    MatchAccumulator accumulatedMatchResult = ComputingMatcher.this.matchAccumulatorSupplier.get();
                    for (i = 0; i < size && (locallyBoundMapOptional = ComputingMatcher.this.mapDependenciesToOther(aliasMap = aliasMapBuilder.build(), alias = (CorrelationIdentifier)permutation.get(i), otherAlias = (CorrelationIdentifier)otherPermutation.get(i))).isPresent(); ++i) {
                        Object otherEntity;
                        AliasMap locallyBoundMap = locallyBoundMapOptional.get();
                        Object entity = Objects.requireNonNull(ComputingMatcher.this.getAliasToElementMap().get(alias));
                        Iterable matchResults = ComputingMatcher.this.matchFunction.apply(entity, otherEntity = Objects.requireNonNull(ComputingMatcher.this.getOtherAliasToElementMap().get(otherAlias)), boundAliasesMap.combine(locallyBoundMap));
                        if (Iterables.isEmpty(matchResults)) break;
                        accumulatedMatchResult.accumulate(matchResults);
                        aliasMapBuilder.put(alias, otherAlias);
                    }
                    Object result = accumulatedMatchResult.finish();
                    if (i == size) {
                        iterator.skip(i - 1);
                        AliasMap finalAliasMap = aliasMapBuilder.build();
                        return BoundMatch.withAliasMapAndMatchResult(boundAliasesMap.combine(finalAliasMap), result);
                    }
                    iterator.skip(i);
                }
                return (BoundMatch)this.endOfData();
            }
        };
    }

    @Nonnull
    public static <T, M, R> GenericMatcher<BoundMatch<R>> onAliasDependencies(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends T> elements, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Function<T, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Collection<? extends T> otherElements, @Nonnull Function<T, CorrelationIdentifier> otherElementToAliasFn, @Nonnull Function<T, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchFunction<T, M> matchFunction, @Nonnull Supplier<MatchAccumulator<M, R>> matchAccumulatorSupplier) {
        ImmutableSet<CorrelationIdentifier> aliases = DependencyUtils.computeAliases(elements, elementToAliasFn);
        ImmutableMap<CorrelationIdentifier, ? extends T> aliasToElementMap = DependencyUtils.computeAliasToElementMap(elements, elementToAliasFn);
        ImmutableSet<CorrelationIdentifier> otherAliases = DependencyUtils.computeAliases(otherElements, otherElementToAliasFn);
        ImmutableMap<CorrelationIdentifier, ? extends T> otherAliasToElementMap = DependencyUtils.computeAliasToElementMap(otherElements, otherElementToAliasFn);
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap = TransitiveClosure.transitiveClosure(aliases, DependencyUtils.computeDependsOnMapWithAliases(aliases, aliasToElementMap, dependsOnFn));
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> otherDependsOnMap = TransitiveClosure.transitiveClosure(otherAliases, DependencyUtils.computeDependsOnMapWithAliases(otherAliases, otherAliasToElementMap, otherDependsOnFn));
        return new ComputingMatcher<T, M, R>(boundAliasesMap, aliases, elementToAliasFn, aliasToElementMap, dependsOnMap, otherAliases, otherElementToAliasFn, otherAliasToElementMap, otherDependsOnMap, matchFunction, matchAccumulatorSupplier);
    }

    @Nonnull
    public static <M> MatchAccumulator<M, EnumeratingIterable<M>> productAccumulator() {
        return new MatchAccumulator<M, EnumeratingIterable<M>>(){
            private final ImmutableList.Builder<Iterable<M>> state = ImmutableList.builder();

            @Override
            public void accumulate(Iterable<M> v) {
                this.state.add(v);
            }

            @Override
            public EnumeratingIterable<M> finish() {
                return CrossProduct.crossProduct(this.state.build());
            }
        };
    }
}

