/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class DependencyUtils {
    private DependencyUtils() {
    }

    @Nonnull
    public static <T> ImmutableSet<CorrelationIdentifier> computeAliases(@Nonnull Iterable<? extends T> elements, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn) {
        return StreamSupport.stream(elements.spliterator(), false).map(elementToAliasFn).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static <T> ImmutableMap<CorrelationIdentifier, T> computeAliasToElementMap(@Nonnull Iterable<? extends T> elements, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn) {
        return StreamSupport.stream(elements.spliterator(), false).collect(ImmutableMap.toImmutableMap(elementToAliasFn, Function.identity()));
    }

    @Nonnull
    public static <T> ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> computeDependsOnMap(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Map<CorrelationIdentifier, T> aliasToElementMap, @Nonnull Function<T, ? extends Collection<T>> dependsOnFn) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (CorrelationIdentifier alias : aliases) {
            Collection<T> dependsOn = dependsOnFn.apply(aliasToElementMap.get(alias));
            for (T dependsOnElement : dependsOn) {
                CorrelationIdentifier dependsOnAlias = elementToAliasFn.apply(dependsOnElement);
                if (dependsOnAlias == null || !aliases.contains(dependsOnAlias)) continue;
                builder.put(alias, dependsOnAlias);
            }
        }
        return builder.build();
    }

    @Nonnull
    public static <T> ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> computeDependsOnMapWithAliases(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Map<CorrelationIdentifier, T> aliasToElementMap, @Nonnull Function<T, Set<CorrelationIdentifier>> dependsOnFn) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (CorrelationIdentifier alias : aliases) {
            Set<CorrelationIdentifier> dependsOn = dependsOnFn.apply(aliasToElementMap.get(alias));
            for (CorrelationIdentifier dependsOnAlias : dependsOn) {
                if (dependsOnAlias == null || !aliases.contains(dependsOnAlias)) continue;
                builder.put(alias, dependsOnAlias);
            }
        }
        return builder.build();
    }
}

