/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.apple.foundationdb.record.query.combinatorics.TransitiveClosure;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BaseMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.DependencyUtils;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchPredicate;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.PredicatedMatcher;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class FindingMatcher<T>
extends BaseMatcher<T>
implements PredicatedMatcher {
    @Nonnull
    private final MatchPredicate<T> matchPredicate;

    private FindingMatcher(@Nonnull AliasMap boundAliasesMap, @Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Map<CorrelationIdentifier, T> aliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<T, CorrelationIdentifier> otherElementToAliasFn, @Nonnull Map<CorrelationIdentifier, ? extends T> otherAliasToElementMap, @Nonnull ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> otherDependsOnMap, @Nonnull MatchPredicate<T> matchPredicate) {
        super(boundAliasesMap, aliases, elementToAliasFn, aliasToElementMap, dependsOnMap, otherAliases, otherElementToAliasFn, otherAliasToElementMap, otherDependsOnMap);
        this.matchPredicate = matchPredicate;
    }

    @Override
    @Nonnull
    public Iterable<AliasMap> findCompleteMatches() {
        return this.match(this::enumerate, true);
    }

    @Override
    @Nonnull
    public Iterable<AliasMap> findMatches() {
        return this.match(this::enumerate, false);
    }

    @Nonnull
    public Iterator<AliasMap> enumerate(final @Nonnull EnumeratingIterator<CorrelationIdentifier> iterator, final @Nonnull List<CorrelationIdentifier> otherOrdered) {
        final Set<CorrelationIdentifier> aliases = this.getAliases();
        final AliasMap boundAliasesMap = this.getBoundAliasesMap();
        if (otherOrdered.isEmpty()) {
            return ImmutableList.of(boundAliasesMap).iterator();
        }
        final int size = otherOrdered.size();
        return new AbstractIterator<AliasMap>(){

            @Override
            protected AliasMap computeNext() {
                while (iterator.hasNext()) {
                    CorrelationIdentifier otherAlias;
                    CorrelationIdentifier alias;
                    AliasMap aliasMap;
                    Optional<AliasMap> dependsOnMapOptional;
                    int i;
                    List ordered = (List)iterator.next();
                    AliasMap.Builder aliasMapBuilder = AliasMap.builder(aliases.size());
                    for (i = 0; i < size && (dependsOnMapOptional = FindingMatcher.this.mapDependenciesToOther(aliasMap = aliasMapBuilder.build(), alias = (CorrelationIdentifier)ordered.get(i), otherAlias = (CorrelationIdentifier)otherOrdered.get(i))).isPresent(); ++i) {
                        Object otherEntity;
                        AliasMap dependsOnMap = dependsOnMapOptional.get();
                        Object entity = Objects.requireNonNull(FindingMatcher.this.getAliasToElementMap().get(alias));
                        if (!FindingMatcher.this.matchPredicate.test(entity, otherEntity = Objects.requireNonNull(FindingMatcher.this.getOtherAliasToElementMap().get(otherAlias)), boundAliasesMap.combine(dependsOnMap))) break;
                        aliasMapBuilder.put(alias, otherAlias);
                    }
                    if (i == size) {
                        iterator.skip(i - 1);
                        return boundAliasesMap.toBuilder(ordered.size()).zip(ordered, otherOrdered, i).build();
                    }
                    iterator.skip(i);
                }
                return (AliasMap)this.endOfData();
            }
        };
    }

    @Nonnull
    public static FindingMatcher<CorrelationIdentifier> onAliases(@Nonnull AliasMap boundAliasesMap, @Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchPredicate<CorrelationIdentifier> matchPredicate) {
        Map<CorrelationIdentifier, CorrelationIdentifier> identityMappingMap = CorrelationIdentifier.identityMappingMap(aliases);
        Map<CorrelationIdentifier, CorrelationIdentifier> otherIdentityMappingMap = CorrelationIdentifier.identityMappingMap(otherAliases);
        return new FindingMatcher<CorrelationIdentifier>(boundAliasesMap, aliases, Function.identity(), identityMappingMap, TransitiveClosure.transitiveClosure(aliases, DependencyUtils.computeDependsOnMap(aliases, Function.identity(), identityMappingMap, dependsOnFn)), otherAliases, Function.identity(), otherIdentityMappingMap, TransitiveClosure.transitiveClosure(otherAliases, DependencyUtils.computeDependsOnMap(otherAliases, Function.identity(), otherIdentityMappingMap, otherDependsOnFn)), matchPredicate);
    }

    @Nonnull
    public static <T> PredicatedMatcher onAliasDependencies(@Nonnull AliasMap boundAliasesMap, @Nonnull Collection<? extends T> elements, @Nonnull Function<T, CorrelationIdentifier> elementToAliasFn, @Nonnull Function<T, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Collection<? extends T> otherElements, @Nonnull Function<T, CorrelationIdentifier> otherElementToAliasFn, @Nonnull Function<T, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchPredicate<T> matchPredicate) {
        ImmutableSet<CorrelationIdentifier> aliases = DependencyUtils.computeAliases(elements, elementToAliasFn);
        ImmutableMap<CorrelationIdentifier, ? extends T> aliasToElementMap = DependencyUtils.computeAliasToElementMap(elements, elementToAliasFn);
        ImmutableSet<CorrelationIdentifier> otherAliases = DependencyUtils.computeAliases(otherElements, otherElementToAliasFn);
        ImmutableMap<CorrelationIdentifier, ? extends T> otherAliasToElementMap = DependencyUtils.computeAliasToElementMap(otherElements, otherElementToAliasFn);
        return new FindingMatcher<T>(boundAliasesMap, aliases, elementToAliasFn, aliasToElementMap, TransitiveClosure.transitiveClosure(aliases, DependencyUtils.computeDependsOnMapWithAliases(aliases, aliasToElementMap, dependsOnFn)), otherAliases, otherElementToAliasFn, otherAliasToElementMap, TransitiveClosure.transitiveClosure(otherAliases, DependencyUtils.computeDependsOnMapWithAliases(otherAliases, otherAliasToElementMap, otherDependsOnFn)), matchPredicate);
    }
}

