/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.graph;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchFunction;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface MatchPredicate<T> {
    public boolean test(@Nonnull T var1, @Nonnull T var2, @Nonnull AliasMap var3);

    default public MatchPredicate<T> and(MatchPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return (entity, otherEntity, equivalencesMap) -> this.test(entity, otherEntity, equivalencesMap) && other.test(entity, otherEntity, equivalencesMap);
    }

    default public <R> MatchFunction<T, R> andThen(MatchFunction<? super T, R> after) {
        Objects.requireNonNull(after);
        return (entity, otherEntity, equivalencesMap) -> {
            if (this.test(entity, otherEntity, equivalencesMap)) {
                return after.apply(entity, otherEntity, equivalencesMap);
            }
            return ImmutableList.of();
        };
    }
}

