/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ContainerMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AnyMatcher<T>
implements ContainerMatcher<T, Iterable<? extends T>> {
    @Nonnull
    private final BindingMatcher<T> downstream;

    public AnyMatcher(@Nonnull BindingMatcher<T> downstream) {
        this.downstream = downstream;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Iterable<? extends T> in) {
        return StreamSupport.stream(in.spliterator(), false).flatMap(item -> this.downstream.bindMatches(plannerConfiguration, outerBindings, item));
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        String downstreamId = this.downstream.identifierFromMatcher();
        String nestedIndentation = indentation + "    ";
        String doubleNestedIndentation = nestedIndentation + "    ";
        return "case " + boundId + ": collection =>" + BindingMatcher.newLine(nestedIndentation) + "match any " + downstreamId + " in " + boundId + " {" + BindingMatcher.newLine(doubleNestedIndentation) + this.downstream.explainMatcher(Object.class, downstreamId, nestedIndentation) + BindingMatcher.newLine(nestedIndentation) + "}";
    }

    @Nonnull
    public static <T> CollectionMatcher<T> any(@Nonnull BindingMatcher<T> downstream) {
        final AnyMatcher<T> anyMatcher = new AnyMatcher<T>(downstream);
        return new CollectionMatcher<T>(){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
                return anyMatcher.bindMatchesSafely(plannerConfiguration, outerBindings, in);
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return anyMatcher.explainMatcher(atLeastType, boundId, indentation);
            }
        };
    }

    @Nonnull
    public static <T> AnyMatcher<T> anyInIterable(@Nonnull BindingMatcher<T> downstream) {
        return new AnyMatcher<T>(downstream);
    }
}

