/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class AnyOfMatcher<T>
implements BindingMatcher<T> {
    @Nonnull
    private final Class<T> staticClassOfT;
    @Nonnull
    private final List<BindingMatcher<?>> downstreams;

    private AnyOfMatcher(@Nonnull Class<T> staticClassOfT, @Nonnull Collection<? extends BindingMatcher<?>> downstreams) {
        this.staticClassOfT = staticClassOfT;
        this.downstreams = ImmutableList.copyOf(downstreams);
    }

    @Override
    @Nonnull
    public Class<T> getRootClass() {
        return this.staticClassOfT;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
        return this.downstreams.stream().flatMap(extractingMatcher -> extractingMatcher.bindMatches(plannerConfiguration, outerBindings, in));
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        String nestedIndentation = indentation + "    ";
        ImmutableList downstreamIds = Streams.mapWithIndex(this.downstreams.stream(), (downstream, index) -> downstream.identifierFromMatcher() + index).collect(ImmutableList.toImmutableList());
        return "all of {" + BindingMatcher.newLine(nestedIndentation) + Streams.zip(this.downstreams.stream(), downstreamIds.stream(), (downstream, downstreamId) -> downstream.explainMatcher(atLeastType, boundId, nestedIndentation)).collect(Collectors.joining(" && " + BindingMatcher.newLine(nestedIndentation))) + BindingMatcher.newLine(indentation) + "}";
    }

    public static <T> AnyOfMatcher<T> matchingAnyOf(@Nonnull Class<T> staticClassOfT, @Nonnull Collection<? extends BindingMatcher<?>> matchingExtractors) {
        return new AnyOfMatcher<T>(staticClassOfT, matchingExtractors);
    }
}

