/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface BindingMatcher<T> {
    public static final String INDENTATION = "    ";

    @Nonnull
    public Class<T> getRootClass();

    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration var1, @Nonnull PlannerBindings var2, @Nonnull T var3);

    @Nonnull
    default public Stream<PlannerBindings> bindMatches(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Object in) {
        if (this.getRootClass().isInstance(in)) {
            return this.bindMatchesSafely(plannerConfiguration, outerBindings, in);
        }
        return Stream.empty();
    }

    default public BindingMatcher<T> where(@Nonnull BindingMatcher<? super T> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(this.getRootClass(), Extractor.identity(), AllOfMatcher.matchingAllOf(this.getRootClass(), ImmutableList.of(this, downstream)));
    }

    default public BindingMatcher<T> where(BindingMatcher<? super T> ... downstreams) {
        return this.where((BindingMatcher<? super T>)AllOfMatcher.matchingAllOf(this.getRootClass(), Arrays.asList(downstreams)));
    }

    default public BindingMatcher<T> where(@Nonnull Collection<? extends BindingMatcher<? super T>> downstreams) {
        return this.where((BindingMatcher<? super T>)AllOfMatcher.matchingAllOf(this.getRootClass(), downstreams));
    }

    default public BindingMatcher<T> and(@Nonnull BindingMatcher<? super T> downstream) {
        return this.where(downstream);
    }

    default public BindingMatcher<T> or(@Nonnull BindingMatcher<? super T> downstream) {
        return AnyOfMatcher.matchingAnyOf(this.getRootClass(), ImmutableList.of(this, downstream));
    }

    public String explainMatcher(@Nonnull Class<?> var1, @Nonnull String var2, @Nonnull String var3);

    default public boolean matches(@Nonnull Object in) {
        return this.bindMatches(RecordQueryPlannerConfiguration.defaultPlannerConfiguration(), PlannerBindings.empty(), in).findAny().isPresent();
    }

    default public boolean matchesExactly(@Nonnull Object in) {
        List plannerBindings = this.bindMatches(RecordQueryPlannerConfiguration.defaultPlannerConfiguration(), PlannerBindings.empty(), in).collect(ImmutableList.toImmutableList());
        return plannerBindings.size() == 1;
    }

    default public String identifierFromMatcher() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.unboundRootClass().getSimpleName());
    }

    default public Class<?> unboundRootClass() {
        try {
            return this.getRootClass();
        }
        catch (RecordCoreException e) {
            return Object.class;
        }
    }

    public static <T> BindingMatcher<T> instance() {
        return new BindingMatcher<T>(){

            @Override
            @Nonnull
            public Class<T> getRootClass() {
                throw new RecordCoreException("getRootClass() should not be called", new Object[0]);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
                throw new RecordCoreException("bindMatchesSafely() should not be called", new Object[0]);
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                throw new RecordCoreException("explainMatcher() should not be called", new Object[0]);
            }
        };
    }

    public static String newLine(@Nonnull String indent) {
        return "\n" + indent;
    }
}

