/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.ChooseK;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ContainerMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.SetMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface CollectionMatcher<T>
extends ContainerMatcher<T, Collection<T>> {
    @Override
    @Nonnull
    default public Class<Collection<T>> getRootClass() {
        return Collection.class;
    }

    public static <T> CollectionMatcher<T> empty() {
        return new CollectionMatcher<T>(){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
                return in.isEmpty() ? Stream.of(PlannerBindings.from(this, in)) : Stream.empty();
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                if (Collection.class.isAssignableFrom(atLeastType)) {
                    return "case " + boundId + " if " + boundId + " isEmpty() => success";
                }
                return "case " + boundId + ":Collection if " + boundId + " isEmpty() => success";
            }
        };
    }

    @Nonnull
    public static <E> CollectionMatcher<E> fromBindingMatcher(final @Nonnull BindingMatcher<Collection<E>> matcher) {
        return new CollectionMatcher<E>(){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<E> in) {
                return matcher.bindMatchesSafely(plannerConfiguration, outerBindings, in);
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return matcher.explainMatcher(atLeastType, boundId, indentation);
            }
        };
    }

    @SafeVarargs
    public static <E> CollectionMatcher<E> choose(@Nonnull BindingMatcher<? extends E> downstream0, @Nonnull BindingMatcher<? extends E> downstream1, BindingMatcher<? extends E> ... downstreamTail) {
        return CollectionMatcher.choose(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(downstream0)).add(downstream1)).addAll(Arrays.asList(downstreamTail))).build());
    }

    public static <E> CollectionMatcher<E> choose(@Nonnull List<? extends BindingMatcher<? extends E>> downstreams) {
        return CollectionMatcher.fromBindingMatcher(TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(element -> ChooseK.chooseK(element, Math.min(element.size(), downstreams.size())), name -> "choose(" + name + ", " + downstreams.size() + ")"), AnyMatcher.anyInIterable(SetMatcher.exactlyInAnyOrder(downstreams))));
    }

    public static <E> CollectionMatcher<E> combinations(@Nonnull CollectionMatcher<? extends E> downstream) {
        return CollectionMatcher.combinations(downstream, (Collection<E> collection) -> 0, Collection::size);
    }

    public static <E> CollectionMatcher<E> combinations(@Nonnull CollectionMatcher<? extends E> downstream, @Nonnull Function<Collection<E>, Integer> startInclusiveFunction, @Nonnull Function<Collection<E>, Integer> endExclusiveFunction) {
        return CollectionMatcher.fromBindingMatcher(TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(collection -> ChooseK.chooseK(collection, (Integer)startInclusiveFunction.apply((Collection)collection), (Integer)endExclusiveFunction.apply((Collection)collection)), name -> "combinations(" + name + ")"), AnyMatcher.anyInIterable(downstream)));
    }

    public static <E> CollectionMatcher<E> combinations(@Nonnull CollectionMatcher<? extends E> downstream, @Nonnull BiFunction<RecordQueryPlannerConfiguration, Collection<E>, Integer> startInclusiveFunction, @Nonnull BiFunction<RecordQueryPlannerConfiguration, Collection<E>, Integer> endExclusiveFunction) {
        return CollectionMatcher.fromBindingMatcher(TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of((plannerConfiguration, collection) -> ChooseK.chooseK(collection, (Integer)startInclusiveFunction.apply(plannerConfiguration, (Collection)collection), (Integer)endExclusiveFunction.apply(plannerConfiguration, (Collection)collection)), name -> "combinations(" + name + ")"), AnyMatcher.anyInIterable(downstream)));
    }
}

