/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartitions;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.OptionalIfPresentMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ExpressionsPartitionMatchers {
    private ExpressionsPartitionMatchers() {
    }

    @Nonnull
    public static BindingMatcher<Reference> expressionPartitions(@Nonnull BindingMatcher<? extends Iterable<? extends ExpressionPartition<? extends RelationalExpression>>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::toExpressionPartitions, name -> "expressionPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<Collection<? extends ExpressionPartition<? extends RelationalExpression>>> filterPartition(@Nonnull Predicate<ExpressionPartition<? extends RelationalExpression>> predicate, @Nonnull BindingMatcher<? extends Iterable<? extends ExpressionPartition<? extends RelationalExpression>>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(planPartitions -> planPartitions.stream().filter(predicate).collect(ImmutableList.toImmutableList()), name -> "filtered expressionPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<Collection<ExpressionPartition<RelationalExpression>>> rollUpPartitions(@Nonnull BindingMatcher<? extends Iterable<ExpressionPartition<RelationalExpression>>> downstream) {
        return ExpressionsPartitionMatchers.rollUpPartitionsTo(downstream, ImmutableSet.of());
    }

    @Nonnull
    public static BindingMatcher<Collection<ExpressionPartition<RelationalExpression>>> rollUpPartitionsTo(@Nonnull BindingMatcher<? extends Iterable<ExpressionPartition<RelationalExpression>>> downstream, @Nonnull ExpressionProperty<?> interestingProperty) {
        return ExpressionsPartitionMatchers.rollUpPartitionsTo(downstream, ImmutableSet.of(interestingProperty));
    }

    @Nonnull
    public static BindingMatcher<Collection<ExpressionPartition<RelationalExpression>>> rollUpPartitionsTo(@Nonnull BindingMatcher<? extends Iterable<ExpressionPartition<RelationalExpression>>> downstream, @Nonnull Set<ExpressionProperty<?>> interestingProperties) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(partitions -> ExpressionPartitions.rollUpTo(partitions, interestingProperties), name -> "rolled up planPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<ExpressionPartition<RelationalExpression>> anyExpressionPartition() {
        return TypedMatcher.typed(ExpressionPartition.class);
    }

    @Nonnull
    public static <E extends RelationalExpression, P extends ExpressionPartition<E>> BindingMatcher<P> filterExpressions(@Nonnull Predicate<E> predicate, @Nonnull BindingMatcher<P> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ExpressionPartition.class, Extractor.of(expressionPartition -> expressionPartition.filter(predicate), name -> "filtered expressions(" + name + ")"), downstream);
    }

    @Nonnull
    public static <C extends Comparable<C>, E extends RelationalExpression> BiFunction<ExpressionPartition<E>, ? super E, C> comparisonByProperty(@Nonnull ExpressionProperty<C> expressionProperty) {
        return (partition, expression) -> (Comparable)partition.getNonPartitioningPropertyValue(expression, expressionProperty);
    }

    @Nonnull
    public static <E extends RelationalExpression> BiFunction<ExpressionPartition<E>, ? super E, Tuple> comparisonByPropertyList(ExpressionProperty<?> ... expressionProperties) {
        return (partition, expression) -> Tuple.fromItems(Arrays.stream(expressionProperties).map(property -> partition.getNonPartitioningPropertyValue(expression, property)).collect(Collectors.toList()));
    }

    @Nonnull
    public static <C extends Comparable<C>, E extends RelationalExpression> BindingMatcher<ExpressionPartition<RelationalExpression>> argmin(@Nonnull ExpressionProperty<C> expressionProperty, @Nonnull BindingMatcher<E> downstream) {
        return ExpressionsPartitionMatchers.argmin(ExpressionsPartitionMatchers.comparisonByProperty(expressionProperty), downstream);
    }

    @Nonnull
    public static <C extends Comparable<C>, E extends RelationalExpression> BindingMatcher<ExpressionPartition<RelationalExpression>> argmin(@Nonnull BiFunction<ExpressionPartition<E>, ? super E, C> comparisonKeyFunction, @Nonnull BindingMatcher<E> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ExpressionPartition.class, Extractor.of(partition -> partition.getExpressions().stream().min(Comparator.comparing(expression -> (Comparable)comparisonKeyFunction.apply((ExpressionPartition)partition, (Object)expression))), name -> "argmin(" + name + ")"), OptionalIfPresentMatcher.present(downstream));
    }

    @Nonnull
    public static <P extends Comparable<P>> BindingMatcher<ExpressionPartition<RelationalExpression>> argmax(@Nonnull ExpressionProperty<P> expressionProperty, @Nonnull BindingMatcher<? extends RelationalExpression> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(partition -> partition.getExpressions().stream().max(Comparator.comparing(expression -> (Comparable)partition.getNonPartitioningPropertyValue(expression, expressionProperty))), name -> "argmax(" + name + ")"), OptionalIfPresentMatcher.present(downstream));
    }
}

