/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Unapply;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.UnapplyWithConfiguration;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class Extractor<T, U>
implements UnapplyWithConfiguration<T, U> {
    @Nonnull
    private final UnapplyWithConfiguration<T, U> unapplyFn;
    @Nonnull
    private final UnaryOperator<String> explainFn;

    public Extractor(@Nonnull Unapply<T, U> unapplyFn, @Nonnull UnaryOperator<String> explainFn) {
        this((RecordQueryPlannerConfiguration plannerConfiguration, T t2) -> unapplyFn.unapply(t2), explainFn);
    }

    public Extractor(@Nonnull UnapplyWithConfiguration<T, U> unapplyFn, @Nonnull UnaryOperator<String> explainFn) {
        this.unapplyFn = unapplyFn;
        this.explainFn = explainFn;
    }

    @Override
    @Nonnull
    public U unapply(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull T t2) {
        return this.unapplyFn.unapply(plannerConfiguration, t2);
    }

    @Nonnull
    public String explainExtraction(@Nonnull String name) {
        return (String)this.explainFn.apply(name);
    }

    public static <T> Extractor<T, T> identity() {
        return new Extractor<Object, Object>(t2 -> t2, name -> name);
    }

    public static <T, U> Extractor<T, U> of(@Nonnull Unapply<T, U> unapply, UnaryOperator<String> explainFn) {
        return new Extractor<T, U>(unapply, explainFn);
    }

    public static <T, U> Extractor<T, U> of(@Nonnull UnapplyWithConfiguration<T, U> unapply, UnaryOperator<String> explainFn) {
        return new Extractor<T, U>(unapply, explainFn);
    }
}

