/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Verify;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class InstanceMatcher<T>
implements BindingMatcher<T> {
    @Nonnull
    private final BindingMatcher<T> otherMatcher;

    public InstanceMatcher(@Nonnull BindingMatcher<T> otherMatcher) {
        this.otherMatcher = otherMatcher;
    }

    @Override
    @Nonnull
    public Class<T> getRootClass() {
        return this.otherMatcher.getRootClass();
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
        Verify.verify(outerBindings.containsKey(this.otherMatcher));
        if (outerBindings.get(this.otherMatcher) == in) {
            return Stream.of(PlannerBindings.from(this, in));
        }
        return Stream.empty();
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        return "case _: " + this.getRootClass().getSimpleName() + " if " + boundId + " is bound in other matcher => success ";
    }

    @Nonnull
    public static <T> BindingMatcher<T> sameInstanceAsBound(@Nonnull BindingMatcher<T> otherMatcher) {
        return new InstanceMatcher<T>(otherMatcher);
    }
}

