/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ListMatcher<T>
implements CollectionMatcher<T> {
    @Nonnull
    private final List<? extends BindingMatcher<? extends T>> downstreams;

    private ListMatcher(@Nonnull List<? extends BindingMatcher<? extends T>> downstreams) {
        Preconditions.checkArgument(!downstreams.isEmpty());
        this.downstreams = downstreams;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
        if (in.size() != this.downstreams.size()) {
            return Stream.empty();
        }
        Stream<PlannerBindings> bindingStream = Stream.of(PlannerBindings.empty());
        Iterator<BindingMatcher<T>> downstreamIterator = this.downstreams.iterator();
        for (T item : in) {
            BindingMatcher<T> downstream = downstreamIterator.next();
            List individualBindings = downstream.bindMatches(plannerConfiguration, outerBindings, item).collect(Collectors.toList());
            if (individualBindings.isEmpty()) {
                return Stream.empty();
            }
            bindingStream = bindingStream.flatMap(existing -> individualBindings.stream().map(existing::mergedWith));
        }
        return bindingStream;
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        String nestedIndentation = indentation + "    ";
        ImmutableList downstreamIds = Streams.mapWithIndex(this.downstreams.stream(), (downstream, index) -> downstream.identifierFromMatcher() + index).collect(ImmutableList.toImmutableList());
        return "(" + String.join((CharSequence)", ", downstreamIds) + ") in " + boundId + " match all {" + BindingMatcher.newLine(nestedIndentation) + Streams.zip(this.downstreams.stream(), downstreamIds.stream(), (downstream, downstreamId) -> downstream.explainMatcher(Object.class, (String)downstreamId, nestedIndentation)).collect(Collectors.joining(" && " + BindingMatcher.newLine(nestedIndentation))) + BindingMatcher.newLine(indentation) + "}";
    }

    @Nonnull
    @SafeVarargs
    public static <T> ListMatcher<T> exactly(BindingMatcher<? extends T> ... downstreams) {
        return new ListMatcher<T>(Arrays.asList(downstreams));
    }

    @Nonnull
    public static <T> ListMatcher<T> exactly(@Nonnull List<? extends BindingMatcher<? extends T>> downstreams) {
        return new ListMatcher<T>(downstreams);
    }

    @Nonnull
    public static <T> ListMatcher<T> only(@Nonnull BindingMatcher<? extends T> downstreams) {
        return new ListMatcher<T>(ImmutableList.of(downstreams));
    }
}

