/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.OptionalIfPresentMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class MatchPartitionMatchers {
    private MatchPartitionMatchers() {
    }

    @Nonnull
    public static <C extends Collection<? extends PartialMatch>> BindingMatcher<MatchPartition> ofMatches(@Nonnull BindingMatcher<C> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(MatchPartition.class, Extractor.of(MatchPartition::getPartialMatches, name -> "partialMatches(" + name + ")"), downstream);
    }

    public static <R extends RelationalExpression, C extends Collection<? extends PartialMatch>> BindingMatcher<MatchPartition> ofExpressionAndMatches(@Nonnull BindingMatcher<R> downstreamExpression, @Nonnull BindingMatcher<C> downstreamMatches) {
        return MatchPartitionMatchers.ofExpressionOptionalAndMatches(OptionalIfPresentMatcher.present(downstreamExpression), downstreamMatches);
    }

    public static <O extends Optional<RelationalExpression>, C extends Collection<? extends PartialMatch>> BindingMatcher<MatchPartition> ofExpressionOptionalAndMatches(@Nonnull BindingMatcher<O> downstreamExpressionOptional, @Nonnull BindingMatcher<C> downstreamMatches) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(MatchPartition.class, Extractor.identity(), AllOfMatcher.matchingAllOf(MatchPartition.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(MatchPartition.class, Extractor.of(matchPartition -> {
            Set<PartialMatch> partialMatches = matchPartition.getPartialMatches();
            Iterator<PartialMatch> iterator = partialMatches.iterator();
            RelationalExpression lastExpression = null;
            while (iterator.hasNext()) {
                PartialMatch partialMatch = iterator.next();
                if (lastExpression == null) {
                    lastExpression = partialMatch.getQueryExpression();
                    continue;
                }
                if (lastExpression == partialMatch.getQueryExpression()) continue;
                return Optional.empty();
            }
            return Optional.ofNullable(lastExpression);
        }, name -> "expressionOptional(" + name + ")"), downstreamExpressionOptional), TypedMatcherWithExtractAndDownstream.typedWithDownstream(MatchPartition.class, Extractor.of(MatchPartition::getPartialMatches, name -> "partialMatches(" + name + ")"), downstreamMatches))));
    }
}

