/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class MultiMatcher<T>
implements CollectionMatcher<T> {
    @Nonnull
    private final BindingMatcher<T> downstream;

    protected MultiMatcher(@Nonnull BindingMatcher<T> downstream) {
        this.downstream = downstream;
    }

    @Nonnull
    protected BindingMatcher<T> getDownstream() {
        return this.downstream;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
        ImmutableList.Builder items = ImmutableList.builder();
        Stream<PlannerBindings> bindingStream = Stream.of(PlannerBindings.empty());
        int counter = 0;
        for (T item : in) {
            List individualBindings = this.downstream.bindMatches(plannerConfiguration, outerBindings, item).collect(Collectors.toList());
            if (individualBindings.isEmpty()) {
                Optional<Stream<PlannerBindings>> onEmptyStreamOptional = this.onEmptyIndividualBindings(bindingStream);
                if (onEmptyStreamOptional.isEmpty()) {
                    return Stream.empty();
                }
                bindingStream = onEmptyStreamOptional.get();
                continue;
            }
            items.add(item);
            ++counter;
            bindingStream = bindingStream.flatMap(existing -> individualBindings.stream().map(existing::mergedWith));
        }
        bindingStream = bindingStream.flatMap(existing -> Stream.of(PlannerBindings.from(this, items.build()).mergedWith((PlannerBindings)existing)));
        return this.onNumberOfMatches(counter, bindingStream);
    }

    @Nonnull
    protected abstract Optional<Stream<PlannerBindings>> onEmptyIndividualBindings(@Nonnull Stream<PlannerBindings> var1);

    protected abstract Stream<PlannerBindings> onNumberOfMatches(int var1, @Nonnull Stream<PlannerBindings> var2);

    @Nonnull
    public static <T> AllMatcher<T> all(@Nonnull BindingMatcher<T> downstream) {
        return new AllMatcher<T>(downstream);
    }

    @Nonnull
    public static <T> SomeMatcher<T> some(@Nonnull BindingMatcher<T> downstream) {
        return new SomeMatcher<T>(downstream);
    }

    @Nonnull
    public static <T> AtLeastMatcher<T> atLeastOne(@Nonnull BindingMatcher<T> downstream) {
        return new AtLeastMatcher<T>(downstream, 1);
    }

    @Nonnull
    public static <T> AtLeastMatcher<T> atLeastTwo(@Nonnull BindingMatcher<T> downstream) {
        return new AtLeastMatcher<T>(downstream, 2);
    }

    public static class AllMatcher<T>
    extends MultiMatcher<T> {
        private AllMatcher(@Nonnull BindingMatcher<T> downstream) {
            super(downstream);
        }

        @Override
        @Nonnull
        protected Optional<Stream<PlannerBindings>> onEmptyIndividualBindings(@Nonnull Stream<PlannerBindings> accumulatedStream) {
            return Optional.empty();
        }

        @Override
        public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
            String nestedIndentation = indentation + "    ";
            String nestedId = this.getDownstream().identifierFromMatcher();
            return "all " + nestedId + " in " + boundId + " {" + BindingMatcher.newLine(nestedIndentation) + this.getDownstream().explainMatcher(Object.class, nestedId, nestedIndentation) + BindingMatcher.newLine(indentation) + "}";
        }

        @Override
        protected Stream<PlannerBindings> onNumberOfMatches(int numberOfMatches, @Nonnull Stream<PlannerBindings> accumulatedStream) {
            return accumulatedStream;
        }
    }

    public static class SomeMatcher<T>
    extends MultiMatcher<T> {
        private SomeMatcher(@Nonnull BindingMatcher<T> downstream) {
            super(downstream);
        }

        @Override
        @Nonnull
        protected Optional<Stream<PlannerBindings>> onEmptyIndividualBindings(@Nonnull Stream<PlannerBindings> accumulatedStream) {
            return Optional.of(accumulatedStream);
        }

        @Override
        public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
            String nestedIndentation = indentation + "    ";
            String nestedId = this.getDownstream().identifierFromMatcher();
            return "some " + nestedId + " in " + boundId + " that match {" + BindingMatcher.newLine(nestedIndentation) + this.getDownstream().explainMatcher(Object.class, nestedId, nestedIndentation) + BindingMatcher.newLine(indentation) + "}";
        }

        @Override
        protected Stream<PlannerBindings> onNumberOfMatches(int numberOfMatches, @Nonnull Stream<PlannerBindings> accumulatedStream) {
            return accumulatedStream;
        }
    }

    public static class AtLeastMatcher<T>
    extends MultiMatcher<T> {
        private final int minNumberOfRequiredMatches;

        private AtLeastMatcher(@Nonnull BindingMatcher<T> downstream, int minNumberOfRequiredMatches) {
            super(downstream);
            Verify.verify(minNumberOfRequiredMatches >= 0);
            this.minNumberOfRequiredMatches = minNumberOfRequiredMatches;
        }

        @Override
        @Nonnull
        protected Optional<Stream<PlannerBindings>> onEmptyIndividualBindings(@Nonnull Stream<PlannerBindings> accumulatedStream) {
            return Optional.of(accumulatedStream);
        }

        @Override
        public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
            String nestedIndentation = indentation + "    ";
            String nestedId = this.getDownstream().identifierFromMatcher();
            return "atLeast(" + this.minNumberOfRequiredMatches + ")" + nestedId + " in " + boundId + " that match {" + BindingMatcher.newLine(nestedIndentation) + this.getDownstream().explainMatcher(Object.class, nestedId, nestedIndentation) + BindingMatcher.newLine(indentation) + "}";
        }

        @Override
        protected Stream<PlannerBindings> onNumberOfMatches(int numberOfMatches, @Nonnull Stream<PlannerBindings> accumulatedStream) {
            if (numberOfMatches >= this.minNumberOfRequiredMatches) {
                return accumulatedStream;
            }
            return Stream.empty();
        }
    }
}

