/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class NotMatcher
implements BindingMatcher<Object> {
    @Nonnull
    private final BindingMatcher<?> downstream;

    public NotMatcher(@Nonnull BindingMatcher<?> downstream) {
        this.downstream = downstream;
    }

    @Override
    @Nonnull
    public Class<Object> getRootClass() {
        return Object.class;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Object in) {
        Optional<PlannerBindings> nestedBindings = this.downstream.bindMatches(plannerConfiguration, outerBindings, in).findFirst();
        if (nestedBindings.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(PlannerBindings.empty());
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        return "not(" + this.downstream.explainMatcher(atLeastType, boundId, indentation) + ")";
    }

    @Nonnull
    public static <T> NotMatcher not(@Nonnull BindingMatcher<T> downstream) {
        return new NotMatcher(downstream);
    }
}

