/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class OptionalIfPresentMatcher<T>
implements BindingMatcher<Optional<T>> {
    @Nonnull
    private final BindingMatcher<?> downstream;

    public OptionalIfPresentMatcher(@Nonnull BindingMatcher<?> downstream) {
        this.downstream = downstream;
    }

    @Override
    @Nonnull
    public Class<Optional<T>> getRootClass() {
        return Optional.class;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Optional<T> in) {
        return Stream.of(PlannerBindings.from(this, in)).flatMap(bindings -> {
            if (!in.isPresent()) {
                return Stream.empty();
            }
            return this.downstream.bindMatches(plannerConfiguration, outerBindings, in.get()).map(bindings::mergedWith);
        });
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        if (Optional.class.isAssignableFrom(atLeastType)) {
            return "case " + boundId + " if " + boundId + " isPresent() => success";
        }
        return "case " + boundId + ":Optional if " + boundId + " isPresent() => success";
    }

    @Nonnull
    public static <T> OptionalIfPresentMatcher<T> present(@Nonnull BindingMatcher<?> downstream) {
        return new OptionalIfPresentMatcher<T>(downstream);
    }
}

