/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PartialMatchMatchers {
    private PartialMatchMatchers() {
    }

    @Nonnull
    public static BindingMatcher<PartialMatch> anyPartialMatch() {
        return new TypedMatcher<PartialMatch>(PartialMatch.class);
    }

    @Nonnull
    public static BindingMatcher<PartialMatch> completeMatch() {
        return new TypedMatcher<PartialMatch>(PartialMatch.class){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull PartialMatch in) {
                return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).flatMap(bindings -> {
                    if (in.getMatchCandidate().getTraversal().getRootReference() != in.getCandidateRef()) {
                        return Stream.empty();
                    }
                    return Stream.of(bindings);
                });
            }
        };
    }

    @Nonnull
    public static BindingMatcher<PartialMatch> incompleteMatch() {
        return new TypedMatcher<PartialMatch>(PartialMatch.class){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull PartialMatch in) {
                return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).flatMap(bindings -> {
                    if (in.getMatchCandidate().getTraversal().getRootReference() == in.getCandidateRef()) {
                        return Stream.empty();
                    }
                    return Stream.of(bindings);
                });
            }
        };
    }

    @Nonnull
    public static BindingMatcher<PartialMatch> matchingWithPrimaryKeyMatchCandidate() {
        return new TypedMatcher<PartialMatch>(PartialMatch.class){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull PartialMatch in) {
                return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).filter(bindings -> in.getMatchCandidate() instanceof WithPrimaryKeyMatchCandidate);
            }
        };
    }

    @Nonnull
    public static BindingMatcher<PartialMatch> matchingAggregateIndexMatchCandidate() {
        return new TypedMatcher<PartialMatch>(PartialMatch.class){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull PartialMatch in) {
                return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).filter(bindings -> in.getMatchCandidate() instanceof AggregateIndexMatchCandidate);
            }
        };
    }
}

