/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartitions;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithPredicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class PlanPartitionMatchers {
    private PlanPartitionMatchers() {
    }

    @Nonnull
    public static BindingMatcher<Reference> planPartitions(@Nonnull BindingMatcher<? extends Iterable<PlanPartition>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::toPlanPartitions, name -> "planPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<Collection<PlanPartition>> filterPlanPartitions(@Nonnull Predicate<PlanPartition> predicate, @Nonnull BindingMatcher<? extends Iterable<PlanPartition>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(planPartitions -> planPartitions.stream().filter(predicate).collect(ImmutableList.toImmutableList()), name -> "filtered planPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<Collection<PlanPartition>> rollUpPartitions(@Nonnull BindingMatcher<? extends Iterable<PlanPartition>> downstream) {
        return PlanPartitionMatchers.rollUpPartitionsTo(downstream, ImmutableSet.of());
    }

    @Nonnull
    public static BindingMatcher<Collection<PlanPartition>> rollUpPartitionsTo(@Nonnull BindingMatcher<? extends Iterable<PlanPartition>> downstream, @Nonnull ExpressionProperty<?> interestingProperty) {
        return PlanPartitionMatchers.rollUpPartitionsTo(downstream, ImmutableSet.of(interestingProperty));
    }

    @Nonnull
    public static BindingMatcher<Collection<PlanPartition>> rollUpPartitionsTo(@Nonnull BindingMatcher<? extends Iterable<PlanPartition>> downstream, @Nonnull Set<ExpressionProperty<?>> interestingProperties) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Collection.class, Extractor.of(partitions -> PlanPartitions.rollUpTo((Collection<PlanPartition>)partitions, interestingProperties), name -> "rolled up planPartitions(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<PlanPartition> anyPlanPartition() {
        return TypedMatcher.typed(PlanPartition.class);
    }

    @Nonnull
    public static BindingMatcher<PlanPartition> planPartitionWhere(@Nonnull Predicate<PlanPartition> predicate) {
        return TypedMatcherWithPredicate.typedMatcherWithPredicate(PlanPartition.class, predicate);
    }
}

