/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class PlannerBindings {
    @Nonnull
    private static final PlannerBindings EMPTY = new PlannerBindings(ImmutableListMultimap.of());
    @Nonnull
    private final ImmutableListMultimap<BindingMatcher<?>, ?> bindings;

    private PlannerBindings(@Nonnull ImmutableListMultimap<BindingMatcher<?>, ?> bindings) {
        this.bindings = bindings;
    }

    public boolean containsKey(@Nonnull BindingMatcher<?> key) {
        return this.bindings.containsKey(key);
    }

    @Nonnull
    public <T> T get(@Nonnull BindingMatcher<T> key) {
        if (this.bindings.containsKey(key)) {
            ImmutableCollection bindingsForKey = this.bindings.get((Object)key);
            if (bindingsForKey.size() == 1) {
                return (T)bindingsForKey.get(0);
            }
            throw new NoSuchElementException("attempted to retrieve individual bindable but multiple keys were bound");
        }
        throw new NoSuchElementException("attempted to extract bindable from binding using non-existent key");
    }

    @Nonnull
    public <T> List<? extends T> getAll(@Nonnull BindingMatcher<T> key) {
        if (this.bindings.containsKey(key)) {
            return this.bindings.get((Object)key);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public PlannerBindings mergedWith(@Nonnull PlannerBindings other) {
        ImmutableListMultimap.Builder combined = ImmutableListMultimap.builder();
        combined.putAll(this.bindings);
        combined.putAll(other.bindings);
        return new PlannerBindings((ImmutableListMultimap<BindingMatcher<?>, ?>)combined.build());
    }

    @Nonnull
    public ImmutableListMultimap<BindingMatcher<?>, ?> asMultiMap() {
        return this.bindings;
    }

    public String toString() {
        return this.bindings.toString();
    }

    @Nonnull
    public static <T> PlannerBindings from(@Nonnull BindingMatcher<T> key, @Nonnull T object) {
        return new PlannerBindings(ImmutableListMultimap.of(key, object));
    }

    @Nonnull
    public static PlannerBindings empty() {
        return EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        @Nonnull
        private final ImmutableListMultimap.Builder<BindingMatcher<?>, Object> map = ImmutableListMultimap.builder();

        @Nonnull
        public <T> Builder put(@Nonnull BindingMatcher<? extends T> key, @Nonnull T bindable) {
            this.map.put((Object)key, (Object)bindable);
            return this;
        }

        @Nonnull
        public <T> Builder putAll(@Nonnull BindingMatcher<? extends T> key, @Nonnull Iterable<? extends T> bindables) {
            this.map.putAll((Object)key, bindables);
            return this;
        }

        @Nonnull
        public Builder putAll(@Nonnull PlannerBindings plannerBindings) {
            this.map.putAll(plannerBindings.bindings);
            return this;
        }

        public PlannerBindings build() {
            return new PlannerBindings((ImmutableListMultimap<BindingMatcher<?>, ?>)this.map.build());
        }
    }
}

