/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PrimitiveMatchers {
    private PrimitiveMatchers() {
    }

    @Nonnull
    public static <T> BindingMatcher<T> equalsObject(@Nonnull T object) {
        return PrimitiveMatchers.testObject(object, Object::equals);
    }

    @Nonnull
    public static <T> BindingMatcher<T> testObject(final @Nonnull T object, final @Nonnull BiPredicate<Object, T> testBiPredicate) {
        return new BindingMatcher<T>(){

            @Override
            @Nonnull
            public Class<T> getRootClass() {
                throw new RecordCoreException("this should return T.class", new Object[0]);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
                throw new RecordCoreException("this should never be called", new Object[0]);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatches(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Object in) {
                return Stream.of(PlannerBindings.from(this, object)).flatMap(bindings -> {
                    if (testBiPredicate.test(in, object)) {
                        return Stream.of(bindings);
                    }
                    return Stream.empty();
                });
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return "match " + boundId + " { case test(" + String.valueOf(object) + ") => success }";
            }
        };
    }

    @Nonnull
    public static <T> CollectionMatcher<T> containsAll(final @Nonnull Set<? extends T> elements) {
        return new CollectionMatcher<T>(){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
                return Stream.of(PlannerBindings.from(this, in)).flatMap(bindings -> {
                    if (in.containsAll(elements)) {
                        return Stream.of(bindings);
                    }
                    return Stream.empty();
                });
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return "match " + boundId + " { case {" + elements.stream().map(Object::toString).collect(Collectors.joining(", ")) + "} in " + boundId + " => success }";
            }
        };
    }

    @Nonnull
    public static <T> BindingMatcher<T> satisfies(final @Nonnull Predicate<T> predicate) {
        return new BindingMatcher<T>(){

            @Override
            @Nonnull
            public Class<T> getRootClass() {
                throw new RecordCoreException("this should return T.class", new Object[0]);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatches(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Object object) {
                Object in = object;
                return this.bindMatchesSafely(plannerConfiguration, outerBindings, in);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
                if (predicate.test(in)) {
                    return Stream.of(PlannerBindings.from(this, in));
                }
                return Stream.empty();
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return "match " + boundId + " { case { predicate.test(" + boundId + ") => success }";
            }
        };
    }

    @Nonnull
    public static <T, T1> BindingMatcher<T> satisfiesWithOuterBinding(final @Nonnull BindingMatcher<T1> outerBindingMatcher, final @Nonnull BiPredicate<T, T1> predicate) {
        return new BindingMatcher<T>(){

            @Override
            @Nonnull
            public Class<T> getRootClass() {
                throw new RecordCoreException("this should return T.class", new Object[0]);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatches(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Object object) {
                Object in = object;
                return this.bindMatchesSafely(plannerConfiguration, outerBindings, in);
            }

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
                Object outerBinding = outerBindings.get(outerBindingMatcher);
                if (predicate.test(in, outerBinding)) {
                    return Stream.of(PlannerBindings.from(this, in));
                }
                return Stream.empty();
            }

            @Override
            public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
                return "match " + boundId + " { case { predicate.test(" + boundId + " with outer binding) => success }";
            }
        };
    }

    @Nonnull
    public static <T> BindingMatcher<T> anyObject() {
        return PrimitiveMatchers.satisfies(t2 -> true);
    }
}

