/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class QuantifierMatchers {
    private QuantifierMatchers() {
    }

    public static <Q extends Quantifier> TypedMatcher<Q> ofType(@Nonnull Class<Q> bindableClass) {
        return TypedMatcher.typed(bindableClass);
    }

    public static <Q extends Quantifier> BindingMatcher<Q> ofTypeRangingOver(@Nonnull Class<Q> bindableClass, @Nonnull BindingMatcher<? extends Collection<? extends RelationalExpression>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(q -> q.getRangesOver().getAllMemberExpressions(), name -> "rangesOver(getAllMemberExpressions(" + name + "))"), downstream);
    }

    public static <Q extends Quantifier> BindingMatcher<Q> ofTypeRangingOverRef(@Nonnull Class<Q> bindableClass, @Nonnull BindingMatcher<? extends Reference> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(Quantifier::getRangesOver, name -> "rangesOver(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier> anyQuantifier() {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.class, ReferenceMatchers.anyRef());
    }

    @Nonnull
    public static BindingMatcher<Quantifier> anyQuantifier(@Nonnull BindingMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<Quantifier> anyQuantifier(@Nonnull CollectionMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.class, downstream);
    }

    public static BindingMatcher<Quantifier> anyQuantifierOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Existential> existentialQuantifier(@Nonnull BindingMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.Existential.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Existential> existentialQuantifier(@Nonnull CollectionMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.Existential.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Existential> existentialQuantifier() {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.Existential.class, ReferenceMatchers.anyRef());
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Existential> existentialQuantifierOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.Existential.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifier() {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.ForEach.class, ReferenceMatchers.anyRef());
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifier(@Nonnull BindingMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.ForEach.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifier(@Nonnull CollectionMatcher<? extends RelationalExpression> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.ForEach.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierWithDefaultOnEmpty() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Quantifier.ForEach.class, Extractor.of(Quantifier.ForEach::isNullOnEmpty, name -> "withDefaultOnEmpty(" + name + ")"), PrimitiveMatchers.equalsObject(true));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.ForEach.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierOverRef(@Nonnull BindingMatcher<? extends Reference> downstream, BindingMatcher<? super Boolean> defaultOnEmptyMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Quantifier.ForEach.class, Extractor.identity(), AllOfMatcher.matchingAllOf(Quantifier.ForEach.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(Quantifier.ForEach.class, Extractor.of(Quantifier.ForEach::isNullOnEmpty, name -> "withDefaultOnEmpty(" + name + ")"), defaultOnEmptyMatcher), TypedMatcherWithExtractAndDownstream.typedWithDownstream(Quantifier.ForEach.class, Extractor.of(Quantifier::getRangesOver, name -> "rangesOver(" + name + ")"), downstream))));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierWithDefaultOnEmptyOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.forEachQuantifierOverRef(downstream, PrimitiveMatchers.equalsObject(true));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierWithoutDefaultOnEmptyOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.forEachQuantifierOverRef(downstream, PrimitiveMatchers.equalsObject(false));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.ForEach> forEachQuantifierOverPlans(@Nonnull CollectionMatcher<RecordQueryPlan> downstream) {
        return QuantifierMatchers.forEachQuantifierOverRef(ReferenceMatchers.members(downstream));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Physical> physicalQuantifier() {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.Physical.class, ReferenceMatchers.anyRef());
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Physical> physicalQuantifier(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.Physical.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Physical> physicalQuantifier(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return QuantifierMatchers.ofTypeRangingOver(Quantifier.Physical.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<Quantifier.Physical> physicalQuantifierOverRef(@Nonnull BindingMatcher<? extends Reference> downstream) {
        return QuantifierMatchers.ofTypeRangingOverRef(Quantifier.Physical.class, downstream);
    }
}

