/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicateWithChild;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class QueryPredicateMatchers {
    private QueryPredicateMatchers() {
    }

    public static TypedMatcher<QueryPredicate> anyPredicate() {
        return QueryPredicateMatchers.ofType(QueryPredicate.class);
    }

    public static TypedMatcher<PredicateWithValue> predicateWithValue() {
        return QueryPredicateMatchers.ofType(PredicateWithValue.class);
    }

    public static <V extends Value> TypedMatcher<ValuePredicate> valuePredicate(@Nonnull BindingMatcher<V> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ValuePredicate.class, Extractor.of(p -> Verify.verifyNotNull(p.getValue()), name -> "comparand(" + name + ")"), downstream);
    }

    public static BindingMatcher<RangeConstraints> rangeConstraint(@Nonnull BindingMatcher<? extends Collection<? extends Comparisons.Comparison>> comparisonBindingMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RangeConstraints.class, Extractor.of(RangeConstraints::getComparisons, name -> "comparisons(" + name + ")"), comparisonBindingMatcher);
    }

    public static <V extends Value, R extends RangeConstraints> TypedMatcher<PredicateWithValueAndRanges> predicateWithValueAndRanges(@Nonnull BindingMatcher<V> downstreamValueMatcher, @Nonnull BindingMatcher<Collection<R>> downstreamRangesMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(PredicateWithValueAndRanges.class, Extractor.identity(), AllOfMatcher.matchingAllOf(PredicateWithValueAndRanges.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(PredicateWithValueAndRanges.class, Extractor.of(PredicateWithValueAndRanges::getValue, name -> "comparator(" + name + ")"), downstreamValueMatcher), TypedMatcherWithExtractAndDownstream.typedWithDownstream(PredicateWithValueAndRanges.class, Extractor.of(PredicateWithValueAndRanges::getRanges, name -> "ranges(" + name + ")"), downstreamRangesMatcher))));
    }

    public static <P extends QueryPredicate> TypedMatcher<P> ofType(@Nonnull Class<P> bindableClass) {
        return TypedMatcher.typed(bindableClass);
    }

    public static <P extends QueryPredicate, C extends Collection<? extends QueryPredicate>> BindingMatcher<P> ofTypeWithChildren(@Nonnull Class<P> bindableClass, @Nonnull BindingMatcher<C> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(TreeLike::getChildren, name -> "children(" + name + ")"), downstream);
    }

    public static <C extends Collection<? extends QueryPredicate>> BindingMatcher<AndPredicate> andPredicate(@Nonnull BindingMatcher<C> downstream) {
        return QueryPredicateMatchers.ofTypeWithChildren(AndPredicate.class, downstream);
    }

    public static TypedMatcher<Comparisons.Comparison> anyComparison() {
        return TypedMatcher.typed(Comparisons.Comparison.class);
    }

    public static TypedMatcher<Comparisons.Comparison> anyComparisonOfType(@Nonnull Comparisons.Type type) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Comparisons.Comparison.class, Extractor.of(Comparisons.Comparison::getType, name -> "type(" + name + ")"), PrimitiveMatchers.equalsObject(type));
    }

    public static TypedMatcher<Comparisons.ValueComparison> anyValueComparison() {
        return TypedMatcher.typed(Comparisons.ValueComparison.class);
    }

    public static TypedMatcher<Comparisons.Comparison> anyUnaryComparison() {
        return TypedMatcherWithPredicate.typedMatcherWithPredicate(Comparisons.Comparison.class, comparison -> comparison.getType().isUnary());
    }

    public static <V extends Value> TypedMatcher<Comparisons.ValueComparison> anyValueComparison(@Nonnull BindingMatcher<V> downstreamValue) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Comparisons.ValueComparison.class, Extractor.of(Comparisons.ValueComparison::getValue, name -> "operand(" + name + ")"), downstreamValue);
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<ValuePredicate> valuePredicate(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull Comparisons.Comparison comparison) {
        return QueryPredicateMatchers.valuePredicate(downstreamValue, PrimitiveMatchers.equalsObject(comparison));
    }

    @Nonnull
    public static <V extends Value, C extends Comparisons.Comparison> BindingMatcher<ValuePredicate> valuePredicate(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull BindingMatcher<C> downstreamComparison) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ValuePredicate.class, Extractor.identity(), AllOfMatcher.matchingAllOf(ValuePredicate.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(ValuePredicate.class, Extractor.of(ValuePredicate::getValue, name -> "value(" + name + ")"), downstreamValue), TypedMatcherWithExtractAndDownstream.typedWithDownstream(ValuePredicate.class, Extractor.of(ValuePredicate::getComparison, name -> "comparison(" + name + ")"), downstreamComparison))));
    }

    @Nonnull
    public static <P extends QueryPredicate> BindingMatcher<OrPredicate> orPredicate(@Nonnull CollectionMatcher<P> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(OrPredicate.class, Extractor.of(AndOrPredicate::getChildren, name -> "children(" + name + ")"), downstream);
    }

    @Nonnull
    public static <P extends QueryPredicate> BindingMatcher<NotPredicate> notPredicate(@Nonnull CollectionMatcher<P> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(NotPredicate.class, Extractor.of(QueryPredicateWithChild::getChildren, name -> "children(" + name + ")"), downstream);
    }
}

