/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.MultidimensionalIndexScanComparisons;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalIntersectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.SetMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.InParameterSource;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.InValuesSource;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAbstractDataModificationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisonKeyValues;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RecordQueryPlanMatchers {
    private RecordQueryPlanMatchers() {
    }

    public static BindingMatcher<RecordQueryPlan> anyPlan() {
        return RelationalExpressionMatchers.ofType(RecordQueryPlan.class);
    }

    @Nonnull
    public static <R extends RecordQueryPlan> BindingMatcher<R> childrenPlans(@Nonnull Class<R> bindableClass, @Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(recordQueryPlan -> {
            List<? extends Quantifier> quantifiers = recordQueryPlan.getQuantifiers();
            List rangedOverPlans = quantifiers.stream().map(quantifier -> quantifier.getRangesOver().getFinalExpressions().stream().collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            return CrossProduct.crossProduct(rangedOverPlans);
        }, name -> "planChildren(" + name + ")"), AnyMatcher.anyInIterable(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> descendantPlans(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(plan -> ImmutableList.copyOf(plan.collectDescendantPlans()), name -> "descendantPlans(" + name + ")"), AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> descendantPlans(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(plan -> ImmutableList.copyOf(plan.collectDescendantPlans()), name -> "descendantPlans(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> selfOrDescendantPlans(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(plan -> ImmutableList.copyOf(Iterables.concat(plan.collectDescendantPlans(), ImmutableList.of(plan))), name -> "selfOrDescendantPlans(" + name + ")"), AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> selfOrDescendantPlans(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(plan -> ImmutableList.copyOf(Iterables.concat(plan.collectDescendantPlans(), ImmutableList.of(plan))), name -> "selfOrDescendantPlans(" + name + ")"), downstream);
    }

    @Nonnull
    @SafeVarargs
    public static ListMatcher<? extends RecordQueryPlan> exactlyPlans(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return ListMatcher.exactly(Arrays.asList(downstreams));
    }

    @Nonnull
    @SafeVarargs
    public static SetMatcher<? extends RecordQueryPlan> exactlyPlansInAnyOrder(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return SetMatcher.exactlyInAnyOrder(Arrays.asList(downstreams));
    }

    public static SetMatcher<? extends RecordQueryPlan> exactlyPlansInAnyOrder(@Nonnull Collection<? extends BindingMatcher<? extends RecordQueryPlan>> downstreams) {
        return SetMatcher.exactlyInAnyOrder(downstreams);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryDefaultOnEmptyPlan> defaultOnEmptyPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryDefaultOnEmptyPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFilterPlan> filter(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryFilterPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFilterPlan> filterPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFilterPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFilterPlan> filterPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFilterPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFilterPlan> queryComponents(@Nonnull CollectionMatcher<? extends QueryComponent> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryFilterPlan.class, Extractor.of(RecordQueryFilterPlan::getFilters, name -> "filters(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryIndexPlan> indexPlan() {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryIndexPlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInJoinPlan> inJoin(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInJoinPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInJoinPlan> inJoinPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInJoinPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInJoinPlan> inJoinPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInJoinPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInParameterJoinPlan> inParameterJoin(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInParameterJoinPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInParameterJoinPlan> inParameterJoinPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInParameterJoinPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInParameterJoinPlan> inParameterJoinPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInParameterJoinPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInComparandJoinPlan> inComparandJoin(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInComparandJoinPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInComparandJoinPlan> inComparandJoinPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInComparandJoinPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInComparandJoinPlan> inComparandJoinPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInComparandJoinPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInParameterJoinPlan> inParameter(@Nonnull BindingMatcher<String> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInParameterJoinPlan.class, Extractor.of(plan -> Objects.requireNonNull(plan.getExternalBinding()), name -> "externalBinding(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInValuesJoinPlan> inValuesJoin(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInValuesJoinPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInValuesJoinPlan> inValuesJoinPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInValuesJoinPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInValuesJoinPlan> inValuesJoinPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInValuesJoinPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInValuesJoinPlan> inValuesList(@Nonnull BindingMatcher<? extends Collection<?>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInValuesJoinPlan.class, Extractor.of(plan -> Objects.requireNonNull(plan.getInListValues()), name -> "values(" + name + ")"), downstream);
    }

    public static <T extends List<?>> BindingMatcher<T> equalsInList(@Nonnull T object) {
        return PrimitiveMatchers.testObject(object, Comparisons::compareListEquals);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlanWithComparisons> scanComparisons(@Nonnull BindingMatcher<ScanComparisons> scanComparisonsBindingMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlanWithComparisons.class, Extractor.of(RecordQueryPlanWithComparisons::getScanComparisons, name -> "comparisons(" + name + ")"), scanComparisonsBindingMatcher);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> isReverse() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(QueryPlan::isReverse, name -> "isReversed(" + name + ")"), PrimitiveMatchers.equalsObject(true));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlan> isNotReverse() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlan.class, Extractor.of(QueryPlan::isReverse, name -> "isNotReversed(" + name + ")"), PrimitiveMatchers.equalsObject(false));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlanWithIndex> indexName(@Nonnull String indexName) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlanWithIndex.class, Extractor.of(RecordQueryPlanWithIndex::getIndexName, name -> "indexName(" + name + ")"), PrimitiveMatchers.equalsObject(indexName));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlanWithIndex> indexScanType(@Nonnull IndexScanType scanType) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlanWithIndex.class, Extractor.of(RecordQueryPlanWithIndex::getScanType, name -> "indexScanType(" + name + ")"), PrimitiveMatchers.equalsObject(scanType));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryIndexPlan> indexScanParameters(@Nonnull BindingMatcher<? extends IndexScanParameters> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryIndexPlan.class, Extractor.of(RecordQueryIndexPlan::getScanParameters, name -> "indexScanParameters(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<MultidimensionalIndexScanComparisons> multidimensional() {
        return TypedMatcher.typed(MultidimensionalIndexScanComparisons.class);
    }

    @Nonnull
    public static BindingMatcher<MultidimensionalIndexScanComparisons> prefix(@Nonnull BindingMatcher<? extends ScanComparisons> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(MultidimensionalIndexScanComparisons.class, Extractor.of(MultidimensionalIndexScanComparisons::getPrefixScanComparisons, name -> "prefix(" + name + ")"), downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<MultidimensionalIndexScanComparisons> dimensions(BindingMatcher<? extends ScanComparisons> ... downstreams) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(MultidimensionalIndexScanComparisons.class, Extractor.of(MultidimensionalIndexScanComparisons::getDimensionsScanComparisons, name -> "dimensions(" + name + ")"), ListMatcher.exactly(downstreams));
    }

    @Nonnull
    public static BindingMatcher<MultidimensionalIndexScanComparisons> suffix(@Nonnull BindingMatcher<? extends ScanComparisons> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(MultidimensionalIndexScanComparisons.class, Extractor.of(MultidimensionalIndexScanComparisons::getSuffixScanComparisons, name -> "suffix(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilter(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryPredicatesFilterPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilter(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryPredicatesFilterPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilter(@Nonnull BindingMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull BindingMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(RecordQueryPredicatesFilterPlan.class, AnyMatcher.any(downstreamPredicates), AnyMatcher.any(downstreamQuantifiers));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilter(@Nonnull CollectionMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull CollectionMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(RecordQueryPredicatesFilterPlan.class, downstreamPredicates, downstreamQuantifiers);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilterPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryPredicatesFilterPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicatesFilterPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryPredicatesFilterPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicates(@Nonnull CollectionMatcher<? extends QueryPredicate> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPredicatesFilterPlan.class, Extractor.of(RecordQueryPredicatesFilterPlan::getPredicates, name -> "predicates(" + name + ")"), downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryPredicatesFilterPlan> predicates(BindingMatcher<? extends QueryPredicate> ... downstreams) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPredicatesFilterPlan.class, Extractor.of(RecordQueryPredicatesFilterPlan::getPredicates, name -> "predicates(" + name + ")"), SetMatcher.exactlyInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryScanPlan> scanPlan() {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryScanPlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<TempTableScanPlan> tempTableScanPlan() {
        return RelationalExpressionMatchers.ofTypeOwning(TempTableScanPlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecordQueryTypeFilterPlan> typeFilter(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryTypeFilterPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryTypeFilterPlan> typeFilter(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryTypeFilterPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryTypeFilterPlan> typeFilterPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryTypeFilterPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryTypeFilterPlan> typeFilterPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryTypeFilterPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryTypeFilterPlan> recordTypes(@Nonnull CollectionMatcher<? extends String> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryTypeFilterPlan.class, Extractor.of(RecordQueryTypeFilterPlan::getRecordTypes, name -> "recordTypes(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnorderedUnionPlan> unorderedUnion(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnorderedUnionPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnorderedUnionPlan> unorderedUnion(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnorderedUnionPlan.class, downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryUnorderedUnionPlan> unorderedUnionPlan(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnorderedUnionPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnorderedUnionPlan> unorderedUnionPlan(@Nonnull Collection<? extends BindingMatcher<? extends RecordQueryPlan>> downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnorderedUnionPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> unionOnExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnionOnKeyExpressionPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> unionOnExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnionOnKeyExpressionPlan.class, downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> unionOnExpressionPlan(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnionOnKeyExpressionPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> unionOnExpressionPlan(@Nonnull Collection<? extends BindingMatcher<? extends RecordQueryPlan>> downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnionOnKeyExpressionPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> comparisonKey(@Nonnull BindingMatcher<KeyExpression> comparisonKeyMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryUnionOnKeyExpressionPlan.class, Extractor.of(RecordQueryUnionOnKeyExpressionPlan::getComparisonKeyExpression, name -> "comparisonKey(" + name + ")"), comparisonKeyMatcher);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnKeyExpressionPlan> comparisonKey(@Nonnull KeyExpression probe) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryUnionOnKeyExpressionPlan.class, Extractor.of(RecordQueryUnionOnKeyExpressionPlan::getComparisonKeyExpression, name -> "comparisonKey(" + name + ")"), PrimitiveMatchers.equalsObject(probe));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnValuesPlan> unionOnValue(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnionOnValuesPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnValuesPlan> unionOnValue(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnionOnValuesPlan.class, downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryUnionOnValuesPlan> unionOnValuesPlan(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnionOnValuesPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnionOnValuesPlan> unionOnValuesPlan(@Nonnull Collection<? extends BindingMatcher<? extends RecordQueryPlan>> downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnionOnValuesPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryPlanWithComparisonKeyValues> comparisonKeyValues(@Nonnull CollectionMatcher<? extends Value> comparisonKeyMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryPlanWithComparisonKeyValues.class, Extractor.of(RecordQueryPlanWithComparisonKeyValues::getComparisonKeyValues, name -> "comparisonKeyValues(" + name + ")"), comparisonKeyMatcher);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnorderedPrimaryKeyDistinctPlan> unorderedPrimaryKeyDistinct(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnorderedPrimaryKeyDistinctPlan.class, AnyMatcher.any(downstream));
    }

    public static BindingMatcher<RecordQueryUnorderedPrimaryKeyDistinctPlan> unorderedPrimaryKeyDistinct(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryUnorderedPrimaryKeyDistinctPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUnorderedPrimaryKeyDistinctPlan> unorderedPrimaryKeyDistinctPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUnorderedPrimaryKeyDistinctPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryIntersectionOnKeyExpressionPlan> intersectionOnExpressionPlan(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryIntersectionOnKeyExpressionPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordQueryIntersectionOnValuesPlan> intersectionOnValuesPlan(BindingMatcher<? extends RecordQueryPlan> ... downstreams) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryIntersectionOnValuesPlan.class, RecordQueryPlanMatchers.exactlyPlansInAnyOrder(downstreams));
    }

    @Nonnull
    public static BindingMatcher<LogicalIntersectionExpression> logicalIntersectionExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalIntersectionExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalIntersectionExpression> logicalIntersectionExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalIntersectionExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryCoveringIndexPlan> coveringIndexPlan() {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryCoveringIndexPlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecordQueryCoveringIndexPlan> indexPlanOf(@Nonnull BindingMatcher<? extends RecordQueryPlanWithIndex> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryCoveringIndexPlan.class, Extractor.of(RecordQueryCoveringIndexPlan::getIndexPlan, name -> "indexPlanOf(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchFromPartialRecord(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryFetchFromPartialRecordPlan.class, AnyMatcher.any(downstream));
    }

    public static BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchFromPartialRecord(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryFetchFromPartialRecordPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFetchFromPartialRecordPlan> fetchFromPartialRecordPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFetchFromPartialRecordPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnKeyExpressionPlan> inUnionOnExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInUnionOnKeyExpressionPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnKeyExpressionPlan> inUnionOnExpressionPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInUnionOnKeyExpressionPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnKeyExpressionPlan> inUnionComparisonKey(@Nonnull BindingMatcher<KeyExpression> comparisonKeyMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInUnionOnKeyExpressionPlan.class, Extractor.of(RecordQueryInUnionOnKeyExpressionPlan::getComparisonKeyExpression, name -> "comparisonKeyExpression(" + name + ")"), comparisonKeyMatcher);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnKeyExpressionPlan> inUnionComparisonKey(@Nonnull KeyExpression probe) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInUnionOnKeyExpressionPlan.class, Extractor.of(RecordQueryInUnionOnKeyExpressionPlan::getComparisonKeyExpression, name -> "comparisonKeyExpression(" + name + ")"), PrimitiveMatchers.equalsObject(probe));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnValuesPlan> inUnionOnValues(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryInUnionOnValuesPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnValuesPlan> inUnionOnValuesPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInUnionOnValuesPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionOnValuesPlan> inUnionComparisonValues(@Nonnull CollectionMatcher<? extends Value> comparisonValuesMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInUnionOnValuesPlan.class, Extractor.of(RecordQueryInUnionOnValuesPlan::getComparisonKeyValues, name -> "comparisonValues(" + name + ")"), comparisonValuesMatcher);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInUnionPlan> inUnionValuesSources(@Nonnull CollectionMatcher<? extends InSource> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryInUnionPlan.class, Extractor.of(RecordQueryInUnionPlan::getInSources, name -> "valuesSources(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<InSource> inUnionBindingName(@Nonnull String bindingName) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(InSource.class, Extractor.of(InSource::getBindingName, name -> "bindingName(" + name + ")"), PrimitiveMatchers.equalsObject(bindingName));
    }

    @Nonnull
    public static BindingMatcher<InValuesSource> inUnionInValues(@Nonnull BindingMatcher<? extends Collection<?>> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(InValuesSource.class, Extractor.of(plan -> Objects.requireNonNull(plan.getValues()), name -> "values(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<InParameterSource> inUnionInParameter(@Nonnull BindingMatcher<String> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(InParameterSource.class, Extractor.of(plan -> Objects.requireNonNull(plan.getParameterName()), name -> "parameter(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> map(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryMapPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> map(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryMapPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> mapPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryMapPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> mapPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryMapPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> mapResult(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryMapPlan.class, Extractor.of(RecordQueryMapPlan::getResultValue, name -> "result(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFlatMapPlan> flatMap(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryFlatMapPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFlatMapPlan> flatMapPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream1, @Nonnull BindingMatcher<? extends RecordQueryPlan> downstream2) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFlatMapPlan.class, ListMatcher.exactly(downstream1, downstream2));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryMapPlan> flatMapPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryMapPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFlatMapPlan> flatMapResult(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryFlatMapPlan.class, Extractor.of(RecordQueryFlatMapPlan::getResultValue, name -> "result(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFirstOrDefaultPlan> firstOrDefault(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryFirstOrDefaultPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFirstOrDefaultPlan> firstOrDefaultPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFirstOrDefaultPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFirstOrDefaultPlan> firstOrDefaultPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryFirstOrDefaultPlan.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryFirstOrDefaultPlan> onEmptyResult(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryFirstOrDefaultPlan.class, Extractor.of(RecordQueryFirstOrDefaultPlan::getOnEmptyResultValue, name -> "onEmptyResult(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryStreamingAggregationPlan> streamingAggregationPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryStreamingAggregationPlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryStreamingAggregationPlan> aggregations(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryStreamingAggregationPlan.class, Extractor.of(RecordQueryStreamingAggregationPlan::getAggregateValue, name -> "aggregation(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryStreamingAggregationPlan> groupings(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryStreamingAggregationPlan.class, Extractor.of(RecordQueryStreamingAggregationPlan::getGroupingValue, name -> "grouping(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryAggregateIndexPlan> aggregateIndexPlan() {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryAggregateIndexPlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecordQueryAggregateIndexPlan> aggregateIndexPlanOf(@Nonnull BindingMatcher<? extends RecordQueryPlanWithIndex> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryAggregateIndexPlan.class, Extractor.of(RecordQueryAggregateIndexPlan::getIndexPlan, name -> "indexPlanOf(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<ComposedBitmapIndexQueryPlan> composedBitmapPlan(@Nonnull CollectionMatcher<? extends RecordQueryPlan> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ComposedBitmapIndexQueryPlan.class, Extractor.of(ComposedBitmapIndexQueryPlan::getIndexPlans, name -> "indexPlans(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<ComposedBitmapIndexQueryPlan> composer(@Nonnull BindingMatcher<ComposedBitmapIndexQueryPlan.ComposerBase> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ComposedBitmapIndexQueryPlan.class, Extractor.of(ComposedBitmapIndexQueryPlan::getComposer, name -> "composer(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<ComposedBitmapIndexQueryPlan.ComposerBase> composition(@Nonnull String compositionString) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ComposedBitmapIndexQueryPlan.ComposerBase.class, Extractor.of(ComposedBitmapIndexQueryPlan.ComposerBase::toString, name -> "composition(" + name + ")"), PrimitiveMatchers.equalsObject(compositionString));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryExplodePlan> explodePlan() {
        return RelationalExpressionMatchers.ofTypeOwning(RecordQueryExplodePlan.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecordQueryExplodePlan> collectionValue(@Nonnull BindingMatcher<? extends Value> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryExplodePlan.class, Extractor.of(RecordQueryExplodePlan::getCollectionValue, name -> "collectionValue(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecordQueryDeletePlan> deletePlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryDeletePlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryInsertPlan> insertPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryInsertPlan.class, RecordQueryPlanMatchers.exactlyPlans(downstream));
    }

    @Nonnull
    public static BindingMatcher<TempTableInsertPlan> tempTableInsertPlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(TempTableInsertPlan.class, RecordQueryPlanMatchers.exactlyPlans(downstream));
    }

    @Nonnull
    public static BindingMatcher<TempTableInsertPlan> tempTableInsertPlanOverQuantifier(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(TempTableInsertPlan.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryUpdatePlan> updatePlan(@Nonnull BindingMatcher<? extends RecordQueryPlan> downstream) {
        return RecordQueryPlanMatchers.childrenPlans(RecordQueryUpdatePlan.class, MultiMatcher.all(downstream));
    }

    @Nonnull
    public static BindingMatcher<RecordQueryAbstractDataModificationPlan> target(@Nonnull BindingMatcher<? extends String> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordQueryAbstractDataModificationPlan.class, Extractor.of(RecordQueryAbstractDataModificationPlan::getTargetRecordType, name -> "target(" + name + ")"), downstream);
    }

    @Nonnull
    public static BindingMatcher<RecursiveUnionExpression> preOrderTraversalIsAllowed() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecursiveUnionExpression.class, Extractor.of(RecursiveUnionExpression::preOrderTraversalAllowed, name -> "preorderTraversal(" + name + ")"), PrimitiveMatchers.equalsObject(true));
    }

    @Nonnull
    public static BindingMatcher<RecursiveUnionExpression> levelTraversalIsAllowed() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecursiveUnionExpression.class, Extractor.of(RecursiveUnionExpression::levelTraversalAllowed, name -> "levelTraversal(" + name + ")"), PrimitiveMatchers.equalsObject(true));
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> hasNoPredicates() {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(SelectExpression.class, Extractor.of(SelectExpression::hasPredicates, name -> "levelTraversal(" + name + ")"), PrimitiveMatchers.equalsObject(false));
    }
}

