/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.MultiMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.RelationalExpressionMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ReferenceMatchers {
    @Nonnull
    private static final BindingMatcher<Reference> topReferenceMatcher = BindingMatcher.instance();
    @Nonnull
    private static final BindingMatcher<Reference> currentReferenceMatcher = BindingMatcher.instance();

    private ReferenceMatchers() {
    }

    @Nonnull
    public static BindingMatcher<Reference> getTopReferenceMatcher() {
        return topReferenceMatcher;
    }

    @Nonnull
    public static BindingMatcher<Reference> getCurrentReferenceMatcher() {
        return currentReferenceMatcher;
    }

    @Nonnull
    public static BindingMatcher<Reference> anyRef() {
        return TypedMatcher.typed(Reference.class);
    }

    @Nonnull
    public static BindingMatcher<Reference> anyRefOverOnlyPlans() {
        return ReferenceMatchers.members(MultiMatcher.all(RelationalExpressionMatchers.ofType(RecordQueryPlan.class)));
    }

    @Nonnull
    public static <E extends RelationalExpression> BindingMatcher<Reference> members(@Nonnull CollectionMatcher<E> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::getAllMemberExpressions, name -> "allMembers(" + name + ")"), downstream);
    }

    @Nonnull
    public static <E extends RelationalExpression> BindingMatcher<Reference> exploratoryMembers(@Nonnull CollectionMatcher<E> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::getExploratoryExpressions, name -> "exploratoryMember(" + name + ")"), downstream);
    }

    @Nonnull
    public static <E extends RelationalExpression> BindingMatcher<Reference> exploratoryMember(@Nonnull BindingMatcher<E> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::getExploratoryExpressions, name -> "exploratoryMember(" + name + ")"), AnyMatcher.any(downstream));
    }

    @Nonnull
    public static <E extends RelationalExpression> BindingMatcher<Reference> finalMember(@Nonnull BindingMatcher<E> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(Reference.class, Extractor.of(Reference::getFinalExpressions, name -> "finalMember(" + name + ")"), AnyMatcher.any(downstream));
    }
}

