/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.DeleteExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.InsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalProjectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalUniqueExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RecursiveUnionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TableFunctionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableInsertExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TempTableScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.UpdateExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AnyMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ReferenceMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalExpressionMatchers {
    private RelationalExpressionMatchers() {
    }

    public static BindingMatcher<RelationalExpression> anyExpression() {
        return TypedMatcher.typed(RelationalExpression.class);
    }

    public static <R extends RelationalExpression> TypedMatcher<R> ofType(@Nonnull Class<R> bindableClass) {
        return TypedMatcher.typed(bindableClass);
    }

    public static <R extends RelationalExpression> BindingMatcher<R> ofType(@Nonnull Class<R> bindableClass, @Nonnull BindingMatcher<R> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.identity(), downstream);
    }

    public static <R extends RelationalExpressionWithPredicates, C extends Collection<? extends Quantifier>> BindingMatcher<R> ofTypeWithPredicates(@Nonnull Class<R> bindableClass, @Nonnull BindingMatcher<C> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(RelationalExpressionWithPredicates::getPredicates, name -> "predicates(" + name + ")"), downstream);
    }

    public static <R extends RelationalExpression, C extends Collection<? extends Quantifier>> BindingMatcher<R> ofTypeOwning(@Nonnull Class<R> bindableClass, @Nonnull BindingMatcher<C> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(RelationalExpression::getQuantifiers, name -> "quantifiers(" + name + ")"), downstream);
    }

    public static <R extends RelationalExpression> BindingMatcher<R> canBeImplemented() {
        return PrimitiveMatchers.satisfies(relationalExpression -> relationalExpression.getQuantifiers().stream().noneMatch(quantifier -> quantifier.getRangesOver().getFinalExpressions().isEmpty()));
    }

    public static <R extends RelationalExpressionWithPredicates, C1 extends Collection<? extends QueryPredicate>, C2 extends Collection<? extends Quantifier>> BindingMatcher<R> ofTypeWithPredicatesAndOwning(@Nonnull Class<R> bindableClass, @Nonnull BindingMatcher<C1> downstreamPredicates, @Nonnull BindingMatcher<C2> downstreamQuantifiers) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.identity(), AllOfMatcher.matchingAllOf(RelationalExpressionWithPredicates.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(RelationalExpressionWithPredicates::getPredicates, name -> "predicates(" + name + ")"), downstreamPredicates), TypedMatcherWithExtractAndDownstream.typedWithDownstream(bindableClass, Extractor.of(RelationalExpression::getQuantifiers, name -> "quantifiers(" + name + ")"), downstreamQuantifiers))));
    }

    public static <Q extends Collection<? extends Quantifier>> BindingMatcher<RelationalExpression> anyExploratoryExpression(@Nonnull BindingMatcher<Q> downstreamQuantifiers) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RelationalExpression.class, Extractor.identity(), AllOfMatcher.matchingAllOf(RelationalExpression.class, ImmutableList.of(PrimitiveMatchers.satisfiesWithOuterBinding(ReferenceMatchers.getCurrentReferenceMatcher(), (expression, currentReference) -> !currentReference.isFinal((RelationalExpression)expression)), TypedMatcherWithExtractAndDownstream.typedWithDownstream(RelationalExpression.class, Extractor.of(RelationalExpression::getQuantifiers, name -> "quantifiers(" + name + ")"), downstreamQuantifiers))));
    }

    public static <E extends RelationalExpression> BindingMatcher<E> isExploratoryExpression() {
        return PrimitiveMatchers.satisfiesWithOuterBinding(ReferenceMatchers.getCurrentReferenceMatcher(), (expression, currentReference) -> !currentReference.isFinal((RelationalExpression)expression));
    }

    @Nonnull
    public static BindingMatcher<FullUnorderedScanExpression> fullUnorderedScanExpression() {
        return RelationalExpressionMatchers.ofTypeOwning(FullUnorderedScanExpression.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<LogicalDistinctExpression> logicalDistinctExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalDistinctExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalDistinctExpression> logicalDistinctExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalDistinctExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalFilterExpression> logicalFilterExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalFilterExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalFilterExpression> logicalFilterExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalFilterExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalFilterExpression> logicalFilterExpression(@Nonnull BindingMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull BindingMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(LogicalFilterExpression.class, AnyMatcher.any(downstreamPredicates), AnyMatcher.any(downstreamQuantifiers));
    }

    @Nonnull
    public static BindingMatcher<LogicalFilterExpression> logicalFilterExpression(@Nonnull CollectionMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull CollectionMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(LogicalFilterExpression.class, downstreamPredicates, downstreamQuantifiers);
    }

    @Nonnull
    public static BindingMatcher<LogicalProjectionExpression> logicalProjectionExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalProjectionExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalProjectionExpression> logicalProjectionExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalProjectionExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalSortExpression> logicalSortExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalSortExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalSortExpression> logicalSortExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalSortExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalTypeFilterExpression> logicalTypeFilterExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalTypeFilterExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalTypeFilterExpression> logicalTypeFilterExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalTypeFilterExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalUnionExpression> logicalUnionExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalUnionExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<LogicalUnionExpression> logicalUnionExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalUnionExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<LogicalUniqueExpression> logicalUniqueExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(LogicalUniqueExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> selectExpression() {
        return RelationalExpressionMatchers.ofType(SelectExpression.class);
    }

    @Nonnull
    public static BindingMatcher<RelationalExpressionWithPredicates> withPredicatesExpression() {
        return RelationalExpressionMatchers.ofType(RelationalExpressionWithPredicates.class);
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> selectExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(SelectExpression.class, AnyMatcher.any(downstream));
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> selectExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(SelectExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> selectExpression(@Nonnull BindingMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull BindingMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(SelectExpression.class, AnyMatcher.any(downstreamPredicates), AnyMatcher.any(downstreamQuantifiers));
    }

    @Nonnull
    public static BindingMatcher<SelectExpression> selectExpression(@Nonnull CollectionMatcher<? extends QueryPredicate> downstreamPredicates, @Nonnull CollectionMatcher<? extends Quantifier> downstreamQuantifiers) {
        return RelationalExpressionMatchers.ofTypeWithPredicatesAndOwning(SelectExpression.class, downstreamPredicates, downstreamQuantifiers);
    }

    @Nonnull
    public static BindingMatcher<ExplodeExpression> explodeExpression() {
        return RelationalExpressionMatchers.ofTypeOwning(ExplodeExpression.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<TableFunctionExpression> tableFunctionExpression() {
        return RelationalExpressionMatchers.ofTypeOwning(TableFunctionExpression.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<GroupByExpression> groupByExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(GroupByExpression.class, ListMatcher.only(downstream));
    }

    @Nonnull
    public static BindingMatcher<GroupByExpression> groupByExpression(@Nonnull BindingMatcher<? extends RecordConstructorValue> downstreamAggregation, @Nonnull CollectionMatcher<? extends Quantifier> downstreamQuantifiers) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(GroupByExpression.class, Extractor.identity(), AllOfMatcher.matchingAllOf(GroupByExpression.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(GroupByExpression.class, Extractor.of(GroupByExpression::getAggregateValue, name -> "aggregation(" + name + ")"), downstreamAggregation), TypedMatcherWithExtractAndDownstream.typedWithDownstream(GroupByExpression.class, Extractor.of(RelationalExpression::getQuantifiers, name -> "quantifiers(" + name + ")"), downstreamQuantifiers))));
    }

    @Nonnull
    public static BindingMatcher<DeleteExpression> deleteExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(DeleteExpression.class, ListMatcher.only(downstream));
    }

    @Nonnull
    public static BindingMatcher<InsertExpression> insertExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(InsertExpression.class, ListMatcher.only(downstream));
    }

    @Nonnull
    public static BindingMatcher<TempTableInsertExpression> tempTableInsertExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(TempTableInsertExpression.class, ListMatcher.only(downstream));
    }

    @Nonnull
    public static BindingMatcher<UpdateExpression> updateExpression(@Nonnull BindingMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(UpdateExpression.class, ListMatcher.only(downstream));
    }

    @Nonnull
    public static BindingMatcher<TempTableScanExpression> tempTableScanExpression() {
        return RelationalExpressionMatchers.ofTypeOwning(TempTableScanExpression.class, CollectionMatcher.empty());
    }

    @Nonnull
    public static BindingMatcher<RecursiveUnionExpression> recursiveUnionExpression(@Nonnull CollectionMatcher<? extends Quantifier> downstream) {
        return RelationalExpressionMatchers.ofTypeOwning(RecursiveUnionExpression.class, downstream);
    }

    @Nonnull
    public static BindingMatcher<RecursiveUnionExpression> recursiveUnionExpression(@Nonnull BindingMatcher<? extends Quantifier> initialDownstream, @Nonnull BindingMatcher<? extends Quantifier> recursiveDownstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecursiveUnionExpression.class, Extractor.identity(), AllOfMatcher.matchingAllOf(RecursiveUnionExpression.class, ImmutableList.of(TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecursiveUnionExpression.class, Extractor.of(RecursiveUnionExpression::getInitialStateQuantifier, name -> "initial(" + name + ")"), initialDownstream), TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecursiveUnionExpression.class, Extractor.of(RecursiveUnionExpression::getRecursiveStateQuantifier, name -> "recursive(" + name + ")"), recursiveDownstream))));
    }
}

