/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class SetMatcher<T>
implements CollectionMatcher<T> {
    @Nonnull
    private final Collection<? extends BindingMatcher<? extends T>> downstreams;

    private SetMatcher(@Nonnull Collection<? extends BindingMatcher<? extends T>> downstreams) {
        this.downstreams = downstreams;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull Collection<T> in) {
        if (in.size() != this.downstreams.size()) {
            return Stream.empty();
        }
        Equivalence<Object> identity = Equivalence.identity();
        ImmutableSet inAsWrappedSet = in.stream().map(identity::wrap).collect(ImmutableSet.toImmutableSet());
        EnumeratingIterable permutations = TopologicalSort.permutations(inAsWrappedSet);
        return StreamSupport.stream(permutations.spliterator(), false).flatMap(permutation -> this.bindMatchesForPermutation(plannerConfiguration, outerBindings, (List<Equivalence.Wrapper<T>>)permutation));
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Stream<PlannerBindings> bindMatchesForPermutation(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull List<Equivalence.Wrapper<T>> permutation) {
        Stream<PlannerBindings> bindingStream = Stream.of(PlannerBindings.empty());
        Iterator<BindingMatcher<T>> downstreamIterator = this.downstreams.iterator();
        for (Equivalence.Wrapper<T> wrappedItem : permutation) {
            T item = Objects.requireNonNull(wrappedItem.get());
            BindingMatcher<T> downstream = downstreamIterator.next();
            Iterator individualBindingsIterator = downstream.bindMatches(plannerConfiguration, outerBindings, item).iterator();
            if (!individualBindingsIterator.hasNext()) {
                return Stream.empty();
            }
            bindingStream = bindingStream.flatMap(existing -> Streams.stream(individualBindingsIterator).map(existing::mergedWith));
        }
        return bindingStream;
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        String nestedIndentation = indentation + "    ";
        ImmutableList downstreamIds = Streams.mapWithIndex(this.downstreams.stream(), (downstream, index) -> downstream.identifierFromMatcher() + index).collect(ImmutableList.toImmutableList());
        return "(" + String.join((CharSequence)", ", downstreamIds) + ") in permutations(" + boundId + ") match all {" + BindingMatcher.newLine(nestedIndentation) + Streams.zip(this.downstreams.stream(), downstreamIds.stream(), (downstream, downstreamId) -> downstream.explainMatcher(Object.class, (String)downstreamId, nestedIndentation) + "," + BindingMatcher.newLine(nestedIndentation)).collect(Collectors.joining()) + BindingMatcher.newLine(indentation) + "}";
    }

    @Nonnull
    @SafeVarargs
    public static <T> SetMatcher<T> exactlyInAnyOrder(BindingMatcher<? extends T> ... downstreams) {
        return new SetMatcher<T>(Arrays.asList(downstreams));
    }

    @Nonnull
    public static <T> SetMatcher<T> exactlyInAnyOrder(@Nonnull Collection<? extends BindingMatcher<? extends T>> downstreams) {
        return new SetMatcher<T>(downstreams);
    }
}

