/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TypedMatcher<T>
implements BindingMatcher<T> {
    @Nonnull
    private final Class<T> bindableClass;

    public TypedMatcher(@Nonnull Class<T> bindableClass) {
        this.bindableClass = bindableClass;
    }

    @Override
    @Nonnull
    public Class<T> getRootClass() {
        return this.bindableClass;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
        return Stream.of(PlannerBindings.from(this, in));
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        if (this.getRootClass().isAssignableFrom(atLeastType)) {
            return "case _ => success ";
        }
        return "case _: " + this.getRootClass().getSimpleName() + " => success ";
    }

    @Nonnull
    public static <T> TypedMatcher<T> typed(@Nonnull Class<T> bindableClass) {
        return new TypedMatcher<T>(bindableClass);
    }
}

