/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TypedMatcherWithExtractAndDownstream<T>
extends TypedMatcher<T> {
    @Nonnull
    private final Extractor<? super T, ?> extractor;
    @Nonnull
    private final BindingMatcher<?> downstream;

    protected TypedMatcherWithExtractAndDownstream(@Nonnull Class<T> bindableClass, @Nonnull Extractor<? super T, ?> extractor, @Nonnull BindingMatcher<?> downstream) {
        super(bindableClass);
        this.extractor = extractor;
        this.downstream = downstream;
    }

    @Nonnull
    public Extractor<? super T, ?> getExtractor() {
        return this.extractor;
    }

    @Nonnull
    public BindingMatcher<?> getDownstream() {
        return this.downstream;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
        return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).flatMap(bindings -> this.downstream.bindMatches(plannerConfiguration, outerBindings, this.extractor.unapply(plannerConfiguration, in)).map(bindings::mergedWith));
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        String nestedId = this.downstream.identifierFromMatcher();
        String nestedIndentation = indentation + "    ";
        String doubleNestedIndentation = nestedIndentation + "    ";
        String typeConstraint = this.getRootClass().isAssignableFrom(atLeastType) ? "" : " if " + boundId + " instanceOf[" + this.getRootClass().getSimpleName() + "]";
        return boundId + " match { " + BindingMatcher.newLine(nestedIndentation) + "case " + this.extractor.explainExtraction(nestedId) + typeConstraint + " => " + BindingMatcher.newLine(doubleNestedIndentation) + this.downstream.explainMatcher(this.downstream.unboundRootClass(), nestedId, doubleNestedIndentation) + BindingMatcher.newLine(indentation) + "}";
    }

    @Nonnull
    public static <S, T extends S> TypedMatcherWithExtractAndDownstream<T> typedWithDownstream(@Nonnull Class<T> bindableClass, @Nonnull Extractor<? super T, ?> extractor, @Nonnull BindingMatcher<?> downstream) {
        return new TypedMatcherWithExtractAndDownstream<T>(bindableClass, extractor, downstream);
    }
}

