/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TypedMatcherWithPredicate<T>
extends TypedMatcher<T> {
    @Nonnull
    private final Predicate<T> predicate;

    protected TypedMatcherWithPredicate(@Nonnull Class<T> bindableClass, @Nonnull Predicate<T> predicate) {
        super(bindableClass);
        this.predicate = predicate;
    }

    @Nonnull
    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    @Override
    @Nonnull
    public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull T in) {
        if (this.predicate.test(in)) {
            return Stream.of(PlannerBindings.from(this, in));
        }
        return Stream.empty();
    }

    @Override
    public String explainMatcher(@Nonnull Class<?> atLeastType, @Nonnull String boundId, @Nonnull String indentation) {
        if (this.getRootClass().isAssignableFrom(atLeastType)) {
            return "case _ if predicate => success ";
        }
        return "case _: " + this.getRootClass().getSimpleName() + " if predicate => success ";
    }

    @Nonnull
    public static <S, T extends S> TypedMatcherWithPredicate<T> typedMatcherWithPredicate(@Nonnull Class<T> bindableClass, @Nonnull Predicate<T> predicate) {
        return new TypedMatcherWithPredicate<T>(bindableClass, predicate);
    }
}

