/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.matching.structure;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.AllOfMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.ListMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NullValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NumericAggregationValue;
import com.apple.foundationdb.record.query.plan.cascades.values.PromoteValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.VariadicFunctionValue;
import com.apple.foundationdb.record.query.plan.cascades.values.VersionValue;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ValueMatchers {
    private ValueMatchers() {
    }

    @Nonnull
    public static BindingMatcher<Value> anyValue() {
        return TypedMatcher.typed(Value.class);
    }

    @Nonnull
    public static BindingMatcher<FieldValue> anyFieldValue() {
        return TypedMatcher.typed(FieldValue.class);
    }

    @Nonnull
    public static BindingMatcher<ConstantObjectValue> anyConstantObjectValue() {
        return TypedMatcher.typed(ConstantObjectValue.class);
    }

    @Nonnull
    public static BindingMatcher<PromoteValue> anyPromoteValue() {
        return TypedMatcher.typed(PromoteValue.class);
    }

    @Nonnull
    public static BindingMatcher<VariadicFunctionValue> anyVariadicFunction() {
        return TypedMatcher.typed(VariadicFunctionValue.class);
    }

    @Nonnull
    public static BindingMatcher<VariadicFunctionValue> variadicFunction(@Nonnull VariadicFunctionValue.ComparisonFunction comparisonFunction) {
        return TypedMatcherWithPredicate.typedMatcherWithPredicate(VariadicFunctionValue.class, variadicFunctionValue -> variadicFunctionValue.getComparisonFunction() == comparisonFunction);
    }

    @Nonnull
    public static BindingMatcher<VariadicFunctionValue> coalesceFunction() {
        return ValueMatchers.variadicFunction(VariadicFunctionValue.ComparisonFunction.COALESCE);
    }

    @Nonnull
    public static BindingMatcher<LiteralValue<Boolean>> anyBooleanLiteralValue() {
        return TypedMatcherWithPredicate.typedMatcherWithPredicate(LiteralValue.class, t2 -> t2.getResultType().getTypeCode() == Type.TypeCode.BOOLEAN);
    }

    @Nonnull
    public static BindingMatcher<NullValue> nullValue() {
        return TypedMatcher.typed(NullValue.class);
    }

    @Nonnull
    public static BindingMatcher<Value> anyNotNullableValue() {
        return TypedMatcherWithPredicate.typedMatcherWithPredicate(Value.class, value -> !value.getResultType().isNullable());
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<FieldValue> fieldValue(@Nonnull BindingMatcher<V> downstreamValueMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getChild, name -> "child(" + name + ")"), downstreamValueMatcher);
    }

    @Nonnull
    public static BindingMatcher<FieldValue> fieldValueWithFieldNames(@Nonnull String fieldPathAsString) {
        return ValueMatchers.fieldValueWithFieldNames(ValueMatchers.anyValue(), fieldPathAsString);
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<FieldValue> fieldValueWithFieldNames(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull String fieldPathAsString) {
        ImmutableList fieldPathMatchers = Arrays.stream(fieldPathAsString.split("\\.")).map(PrimitiveMatchers::equalsObject).collect(ImmutableList.toImmutableList());
        return ValueMatchers.fieldValueWithFieldNames(downstreamValue, ListMatcher.exactly(fieldPathMatchers));
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<FieldValue> fieldValueWithFieldNames(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull CollectionMatcher<String> downstreamFieldPath) {
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamValueMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getChild, name -> "child(" + name + ")"), downstreamValue);
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamFieldPathMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getFieldPathNames, name -> "fieldPathNames(" + name + ")"), downstreamFieldPath);
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.identity(), AllOfMatcher.matchingAllOf(FieldValue.class, ImmutableList.of(downstreamValueMatcher, downstreamFieldPathMatcher)));
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<FieldValue> fieldValueWithLastFieldName(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull BindingMatcher<String> downstreamFieldNameMatcher) {
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamValueMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getChild, name -> "child(" + name + ")"), downstreamValue);
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamFieldPathMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(fieldValue -> {
            List<String> fieldPathNames = fieldValue.getFieldPathNames();
            return fieldPathNames.get(fieldPathNames.size() - 1);
        }, name -> "fieldPathNames(" + name + ")"), downstreamFieldNameMatcher);
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.identity(), AllOfMatcher.matchingAllOf(FieldValue.class, ImmutableList.of(downstreamValueMatcher, downstreamFieldPathMatcher)));
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<FieldValue> fieldValueWithFieldPath(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull CollectionMatcher<Integer> downstreamFieldPathOrdinals, @Nonnull CollectionMatcher<Type> downstreamFieldPathTypes) {
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamValueMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getChild, name -> "child(" + name + ")"), downstreamValue);
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamFieldPathOrdinalsMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(f -> f.getFieldOrdinals().asList(), name -> "fieldPathOrdinals(" + name + ")"), downstreamFieldPathOrdinals);
        TypedMatcherWithExtractAndDownstream<FieldValue> downstreamFieldPathTypesMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.of(FieldValue::getFieldPathTypes, name -> "fieldPathTypes(" + name + ")"), downstreamFieldPathTypes);
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(FieldValue.class, Extractor.identity(), AllOfMatcher.matchingAllOf(FieldValue.class, ImmutableList.of(downstreamValueMatcher, downstreamFieldPathOrdinalsMatcher, downstreamFieldPathTypesMatcher)));
    }

    public static BindingMatcher<NumericAggregationValue.Sum> sumAggregationValue() {
        return ValueMatchers.sumAggregationValue(ValueMatchers.anyValue());
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<NumericAggregationValue.Sum> sumAggregationValue(@Nonnull BindingMatcher<V> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(NumericAggregationValue.Sum.class, Extractor.of(NumericAggregationValue::getChild, name -> "child(" + name + ")"), downstream);
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<NumericAggregationValue.BitmapConstructAgg> bitmapConstructAggValue(@Nonnull BindingMatcher<V> downstream) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(NumericAggregationValue.BitmapConstructAgg.class, Extractor.of(NumericAggregationValue::getChild, name -> "child(" + name + ")"), downstream);
    }

    @Nonnull
    @SafeVarargs
    public static BindingMatcher<RecordConstructorValue> recordConstructorValue(BindingMatcher<? extends Value> ... downstreamValues) {
        return ValueMatchers.recordConstructorValue(ListMatcher.exactly(Arrays.asList(downstreamValues)));
    }

    @Nonnull
    public static BindingMatcher<RecordConstructorValue> recordConstructorValue(@Nonnull CollectionMatcher<? extends Value> downstreamValues) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(RecordConstructorValue.class, Extractor.of(AbstractValue::getChildren, name -> "children(" + name + ")"), downstreamValues);
    }

    @Nonnull
    public static BindingMatcher<ArithmeticValue> arithmeticValue(@Nonnull CollectionMatcher<? extends Value> downstreamValues) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ArithmeticValue.class, Extractor.of(AbstractValue::getChildren, name -> "children(" + name + ")"), downstreamValues);
    }

    @Nonnull
    public static BindingMatcher<StreamableAggregateValue> streamableAggregateValue() {
        return ValueMatchers.streamableAggregateValue(ListMatcher.exactly(ImmutableList.of(ValueMatchers.anyValue())));
    }

    @Nonnull
    public static BindingMatcher<StreamableAggregateValue> streamableAggregateValue(@Nonnull CollectionMatcher<? extends Value> downstreamValues) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(StreamableAggregateValue.class, Extractor.of(TreeLike::getChildren, name -> "children(" + name + ")"), downstreamValues);
    }

    @Nonnull
    public static BindingMatcher<VersionValue> versionValue() {
        return TypedMatcher.typed(VersionValue.class);
    }

    @Nonnull
    public static BindingMatcher<QuantifiedObjectValue> quantifiedObjectValue() {
        return TypedMatcher.typed(QuantifiedObjectValue.class);
    }

    @Nonnull
    public static BindingMatcher<ToOrderedBytesValue> toOrderedBytesValue(@Nonnull CollectionMatcher<? extends Value> downstreamValues) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ToOrderedBytesValue.class, Extractor.of(AbstractValue::getChildren, name -> "children(" + name + ")"), downstreamValues);
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<ToOrderedBytesValue> toOrderedBytesValue(@Nonnull BindingMatcher<V> downstreamValueMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ToOrderedBytesValue.class, Extractor.of(ToOrderedBytesValue::getChild, name -> "child(" + name + ")"), downstreamValueMatcher);
    }

    @Nonnull
    public static <V extends Value> BindingMatcher<ToOrderedBytesValue> toOrderedBytesValue(@Nonnull BindingMatcher<V> downstreamValue, @Nonnull TupleOrdering.Direction direction) {
        TypedMatcherWithExtractAndDownstream<ToOrderedBytesValue> downstreamValueMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(ToOrderedBytesValue.class, Extractor.of(ToOrderedBytesValue::getChild, name -> "child(" + name + ")"), downstreamValue);
        TypedMatcherWithExtractAndDownstream<ToOrderedBytesValue> downstreamDirectionMatcher = TypedMatcherWithExtractAndDownstream.typedWithDownstream(ToOrderedBytesValue.class, Extractor.of(ToOrderedBytesValue::getDirection, name -> "direction(" + name + ")"), PrimitiveMatchers.equalsObject(direction));
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ToOrderedBytesValue.class, Extractor.identity(), AllOfMatcher.matchingAllOf(ToOrderedBytesValue.class, ImmutableList.of(downstreamValueMatcher, downstreamDirectionMatcher)));
    }
}

