/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PAbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AbstractQueryPredicate
implements QueryPredicate {
    private final boolean isAtomic;
    private final Supplier<Set<CorrelationIdentifier>> correlatedToSupplier;
    private final Supplier<Integer> semanticHashCodeSupplier;
    private final Supplier<Integer> heightSupplier;

    protected AbstractQueryPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAbstractQueryPredicate abstractQueryPredicateProto) {
        this(PlanSerialization.getFieldOrThrow(abstractQueryPredicateProto, PAbstractQueryPredicate::hasIsAtomic, PAbstractQueryPredicate::getIsAtomic));
    }

    protected AbstractQueryPredicate(boolean isAtomic) {
        this.isAtomic = isAtomic;
        this.correlatedToSupplier = Suppliers.memoize(this::computeCorrelatedTo);
        this.semanticHashCodeSupplier = Suppliers.memoize(this::computeSemanticHashCode);
        this.heightSupplier = Suppliers.memoize(() -> QueryPredicate.super.height());
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.correlatedToSupplier.get();
    }

    @Nonnull
    private Set<CorrelationIdentifier> computeCorrelatedTo() {
        return this.fold(QueryPredicate::getCorrelatedToWithoutChildren, (correlatedToWithoutChildren, childrenCorrelatedTo) -> {
            ImmutableSet.Builder correlatedToBuilder = ImmutableSet.builder();
            correlatedToBuilder.addAll((Iterable)correlatedToWithoutChildren);
            childrenCorrelatedTo.forEach(correlatedToBuilder::addAll);
            return correlatedToBuilder.build();
        });
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public int semanticHashCode() {
        return this.semanticHashCodeSupplier.get();
    }

    protected abstract int computeSemanticHashCode();

    @Override
    public int height() {
        return this.heightSupplier.get();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(this.isAtomic);
    }

    @Nonnull
    public String toString() {
        return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    @Nonnull
    public PAbstractQueryPredicate toAbstractQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PAbstractQueryPredicate.newBuilder().setIsAtomic(this.isAtomic).build();
    }
}

