/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PAndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AndOrPredicate
extends AbstractQueryPredicate {
    @Nonnull
    private final List<QueryPredicate> children;
    private final Supplier<Set<QueryPredicate>> childrenAsSetSupplier = Suppliers.memoize(() -> ImmutableSet.copyOf(this.getChildren()));

    protected AndOrPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndOrPredicate andOrPredicateProto) {
        super(serializationContext, Objects.requireNonNull(andOrPredicateProto.getSuper()));
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (int i = 0; i < andOrPredicateProto.getChildrenCount(); ++i) {
            childrenBuilder.add(QueryPredicate.fromQueryPredicateProto(serializationContext, andOrPredicateProto.getChildren(i)));
        }
        this.children = childrenBuilder.build();
    }

    protected AndOrPredicate(@Nonnull List<? extends QueryPredicate> children, boolean isAtomic) {
        super(isAtomic);
        if (children.size() < 2) {
            throw new RecordCoreException(this.getClass().getSimpleName() + " must have at least two children", new Object[0]);
        }
        this.children = ImmutableList.copyOf(children);
    }

    @Override
    @Nonnull
    public List<? extends QueryPredicate> getChildren() {
        return this.children;
    }

    @Nonnull
    private Set<QueryPredicate> getChildrenAsSet() {
        return this.childrenAsSetSupplier.get();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsForChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        Optional<AndOrPredicate> andOrPredicateOptional = other.narrowMaybe(AndOrPredicate.class);
        if (andOrPredicateOptional.isEmpty()) {
            return ConstrainedBoolean.falseValue();
        }
        AndOrPredicate that = andOrPredicateOptional.get();
        return valueEquivalence.semanticEquals(this.getChildrenAsSet(), that.getChildrenAsSet());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return Objects.hash(this.hashCodeWithoutChildren(), ImmutableSet.copyOf(this.getChildren()));
    }

    @Nonnull
    public PAndOrPredicate toAndOrPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        PAndOrPredicate.Builder builder = PAndOrPredicate.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext));
        for (QueryPredicate child : this.children) {
            builder.addChildren(child.toQueryPredicateProto(serializationContext));
        }
        return builder.build();
    }

    protected static List<? extends QueryPredicate> toList(@Nonnull QueryPredicate first, @Nonnull QueryPredicate second, QueryPredicate ... operands) {
        ArrayList<QueryPredicate> children = new ArrayList<QueryPredicate>(operands.length + 2);
        children.add(first);
        children.add(second);
        Collections.addAll(children, operands);
        return children;
    }
}

