/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PAndPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AndPredicate
extends AndOrPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("And-Predicate");

    private AndPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndPredicate andPredicateProto) {
        super(serializationContext, Objects.requireNonNull(andPredicateProto.getSuper()));
    }

    private AndPredicate(@Nonnull List<? extends QueryPredicate> children, boolean isAtomic) {
        super(children, isAtomic);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Boolean defaultValue = Boolean.TRUE;
        for (QueryPredicate child : this.getChildren()) {
            Boolean val = child.eval(store, context);
            if (val == null) {
                defaultValue = null;
                continue;
            }
            if (val.booleanValue()) continue;
            return false;
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.AND, new ExplainTokens().addSequence(() -> new ExplainTokens().addWhitespace().addKeyword("AND").addWhitespace(), () -> Streams.stream(explainSuppliers).map(Supplier::get).map(ExplainTokensWithPrecedence.Precedence.AND::parenthesizeChild).iterator()));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.planHash(PlanHashable.CURRENT_FOR_CONTINUATION), super.hashCodeWithoutChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                ArrayList<ObjectPlanHash> hashables = new ArrayList<ObjectPlanHash>(this.getChildren().size() + 1);
                hashables.add(BASE_HASH);
                hashables.addAll((Collection<ObjectPlanHash>)this.getChildren());
                return PlanHashable.planHashUnordered(mode, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public AndPredicate withChildren(Iterable<? extends QueryPredicate> newChildren) {
        return new AndPredicate(ImmutableList.copyOf(newChildren), this.isAtomic());
    }

    @Override
    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull List<PredicateMultiMap.PredicateCompensationFunction> childrenCompensationFunctions, @Nonnull PullUp pullUp) {
        boolean isNeeded = false;
        for (PredicateMultiMap.PredicateCompensationFunction childPredicateCompensationFunction : childrenCompensationFunctions) {
            isNeeded |= childPredicateCompensationFunction.isNeeded();
            if (!childPredicateCompensationFunction.isImpossible()) continue;
            return PredicateMultiMap.PredicateCompensationFunction.impossibleCompensation();
        }
        if (!isNeeded) {
            return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
        }
        return PredicateMultiMap.PredicateCompensationFunction.ofChildrenCompensationFunctions(childrenCompensationFunctions, (functions, baseAlias) -> functions.stream().filter(PredicateMultiMap.PredicateCompensationFunction::isNeeded).flatMap(predicateCompensationFunction -> predicateCompensationFunction.applyCompensationForPredicate((TranslationMap)baseAlias).stream()).collect(LinkedIdentitySet.toLinkedIdentitySet()));
    }

    @Override
    @Nonnull
    public AndPredicate withAtomicity(boolean isAtomic) {
        return new AndPredicate(ImmutableList.copyOf(this.getChildren()), isAtomic);
    }

    @Override
    @Nonnull
    public PAndPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PAndPredicate.newBuilder().setSuper(this.toAndOrPredicateProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setAndPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static AndPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndPredicate andPredicateProto) {
        return new AndPredicate(serializationContext, andPredicateProto);
    }

    public static QueryPredicate and(@Nonnull QueryPredicate first, @Nonnull QueryPredicate second, QueryPredicate ... operands) {
        return AndPredicate.and(AndPredicate.toList(first, second, operands), false);
    }

    @Nonnull
    public static QueryPredicate and(@Nonnull Collection<? extends QueryPredicate> conjuncts) {
        return AndPredicate.and(conjuncts, false);
    }

    @Nonnull
    public static QueryPredicate and(@Nonnull Collection<? extends QueryPredicate> conjuncts, boolean isAtomic) {
        ImmutableList filteredConjuncts = conjuncts.stream().filter(queryPredicate -> !queryPredicate.isTautology()).collect(ImmutableList.toImmutableList());
        if (filteredConjuncts.isEmpty()) {
            return ConstantPredicate.TRUE;
        }
        if (filteredConjuncts.size() == 1) {
            return (QueryPredicate)Iterables.getOnlyElement(filteredConjuncts);
        }
        return new AndPredicate(filteredConjuncts, isAtomic);
    }

    @Nonnull
    public static List<? extends QueryPredicate> conjuncts(@Nonnull QueryPredicate queryPredicate) {
        if (queryPredicate.isTautology()) {
            return ImmutableList.of();
        }
        if (queryPredicate instanceof AndPredicate) {
            return ((AndPredicate)queryPredicate).getChildren();
        }
        return ImmutableList.of(queryPredicate);
    }

    public static class Deserializer
    implements PlanDeserializer<PAndPredicate, AndPredicate> {
        @Override
        @Nonnull
        public Class<PAndPredicate> getProtoMessageClass() {
            return PAndPredicate.class;
        }

        @Override
        @Nonnull
        public AndPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PAndPredicate andPredicateProto) {
            return AndPredicate.fromProto(serializationContext, andPredicateProto);
        }
    }
}

