/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.planprotos.PCompatibleTypeEvolutionPredicate;
import com.apple.foundationdb.record.planprotos.PFieldAccessTrieNode;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.properties.DerivationsProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FirstOrDefaultStreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FirstOrDefaultValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LeafValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.TrieNode;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CompatibleTypeEvolutionPredicate
extends AbstractQueryPredicate
implements LeafQueryPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Compatible-Type-Evolution-Predicate");
    @Nonnull
    private final Map<String, FieldAccessTrieNode> recordTypeNameFieldAccessMap;

    public CompatibleTypeEvolutionPredicate(@Nonnull Map<String, FieldAccessTrieNode> recordTypeNameFieldAccessMap) {
        super(true);
        this.recordTypeNameFieldAccessMap = ImmutableMap.copyOf(recordTypeNameFieldAccessMap);
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        RecordMetaData recordMetaData = Objects.requireNonNull(store).getRecordMetaData();
        Map<String, RecordType> currentRecordTypes = recordMetaData.getRecordTypes();
        for (Map.Entry<String, FieldAccessTrieNode> entry : this.recordTypeNameFieldAccessMap.entrySet()) {
            FieldAccessTrieNode fieldAccessTrieNode = entry.getValue();
            if (!currentRecordTypes.containsKey(entry.getKey())) {
                return false;
            }
            Type.Record currentType = Type.Record.fromFieldDescriptorsMap(recordMetaData.getFieldDescriptorMapFromNames(ImmutableList.of(entry.getKey())));
            if (CompatibleTypeEvolutionPredicate.isAccessCompatibleWithCurrentType(fieldAccessTrieNode, currentType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeSemanticHashCode() {
        return LeafQueryPredicate.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, super.hashCodeWithoutChildren(), this.recordTypeNameFieldAccessMap);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.isAtomic(), this.recordTypeNameFieldAccessMap);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("compatibleTypeEvolution"));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return super.equalsWithoutChildren(other, valueEquivalence).filter(ignored -> {
            CompatibleTypeEvolutionPredicate otherCompatibleTypeEvolutionPredicate = (CompatibleTypeEvolutionPredicate)other;
            return this.recordTypeNameFieldAccessMap.equals(otherCompatibleTypeEvolutionPredicate.recordTypeNameFieldAccessMap);
        });
    }

    @Override
    @Nonnull
    public PCompatibleTypeEvolutionPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        PCompatibleTypeEvolutionPredicate.Builder builder = PCompatibleTypeEvolutionPredicate.newBuilder();
        for (Map.Entry<String, FieldAccessTrieNode> entry : this.recordTypeNameFieldAccessMap.entrySet()) {
            builder.addRecordTypeNameFieldAccessPairs(PCompatibleTypeEvolutionPredicate.PRecordTypeNameFieldAccessPair.newBuilder().setRecordTypeName(entry.getKey()).setFieldAccessTrieNode(entry.getValue().toProto(serializationContext)));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setCompatibleTypeEvolutionPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static CompatibleTypeEvolutionPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCompatibleTypeEvolutionPredicate compatibleTypeEvolutionPredicateProto) {
        ImmutableMap.Builder<String, FieldAccessTrieNode> mapBuilder = ImmutableMap.builder();
        for (int i = 0; i < compatibleTypeEvolutionPredicateProto.getRecordTypeNameFieldAccessPairsCount(); ++i) {
            PCompatibleTypeEvolutionPredicate.PRecordTypeNameFieldAccessPair recordTypeNameFieldAccessPair = compatibleTypeEvolutionPredicateProto.getRecordTypeNameFieldAccessPairs(i);
            mapBuilder.put(Objects.requireNonNull(recordTypeNameFieldAccessPair.getRecordTypeName()), FieldAccessTrieNode.fromProto(serializationContext, Objects.requireNonNull(recordTypeNameFieldAccessPair.getFieldAccessTrieNode())));
        }
        return new CompatibleTypeEvolutionPredicate(mapBuilder.build());
    }

    @Nonnull
    public static Map<String, FieldAccessTrieNode> computeFieldAccesses(@Nonnull List<Value> derivationValues) {
        LinkedHashMap buildersMap = Maps.newLinkedHashMap();
        derivationValues.forEach(derivationValue -> CompatibleTypeEvolutionPredicate.computeFieldAccessForDerivation(buildersMap, derivationValue));
        ImmutableMap.Builder<String, FieldAccessTrieNode> resultMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : buildersMap.entrySet()) {
            resultMapBuilder.put((String)entry.getKey(), ((FieldAccessTrieNodeBuilder)entry.getValue()).build());
        }
        return resultMapBuilder.build();
    }

    @Nonnull
    private static List<FieldAccessTrieNodeBuilder> computeFieldAccessForDerivation(@Nonnull Map<String, FieldAccessTrieNodeBuilder> recordTypeNameTrieBuilderMap, @Nonnull Value derivationValue) {
        if (derivationValue instanceof QueriedValue) {
            QueriedValue queriedValue = (QueriedValue)derivationValue;
            List<String> recordTypeNames = queriedValue.getRecordTypeNames();
            if (recordTypeNames != null) {
                ImmutableList.Builder resultTrieBuilders = ImmutableList.builder();
                for (String recordTypeName : recordTypeNames) {
                    FieldAccessTrieNodeBuilder trieBuilder = recordTypeNameTrieBuilderMap.computeIfAbsent(recordTypeName, rTN -> new FieldAccessTrieNodeBuilder(queriedValue.getResultType()));
                    resultTrieBuilders.add(trieBuilder);
                }
                return resultTrieBuilders.build();
            }
            return ImmutableList.of();
        }
        if (derivationValue instanceof LeafValue) {
            return ImmutableList.of();
        }
        ImmutableList.Builder nestedResultsbuilder = ImmutableList.builder();
        for (Value child : derivationValue.getChildren()) {
            nestedResultsbuilder.add(CompatibleTypeEvolutionPredicate.computeFieldAccessForDerivation(recordTypeNameTrieBuilderMap, child));
        }
        ImmutableCollection nestedResults = nestedResultsbuilder.build();
        if (derivationValue instanceof FieldValue) {
            Verify.verify(nestedResults.size() == 1);
            List nestedTrieBuilders = (List)nestedResults.get(0);
            FieldValue fieldValue = (FieldValue)derivationValue;
            FieldValue.FieldPath fieldPath = fieldValue.getFieldPath();
            ImmutableList.Builder resultTrieBuilders = ImmutableList.builder();
            Iterator iterator = nestedTrieBuilders.iterator();
            while (iterator.hasNext()) {
                FieldAccessTrieNodeBuilder nestedTrieBuilder;
                FieldAccessTrieNodeBuilder currentTrieBuilder = nestedTrieBuilder = (FieldAccessTrieNodeBuilder)iterator.next();
                for (FieldValue.ResolvedAccessor fieldAccessor : fieldPath.getFieldAccessors()) {
                    Type type = currentTrieBuilder.getCurrentType();
                    while (type.isArray()) {
                        type = Objects.requireNonNull(((Type.Array)type).getElementType());
                    }
                    Verify.verify(type.isRecord());
                    Type.Record.Field field = ((Type.Record)type).getField(fieldAccessor.getOrdinal());
                    currentTrieBuilder = currentTrieBuilder.compute(FieldValue.ResolvedAccessor.of(field.getFieldName(), fieldAccessor.getOrdinal(), fieldAccessor.getType()), (resolvedAccessor, oldTrieBuilder) -> {
                        if (oldTrieBuilder == null) {
                            return new FieldAccessTrieNodeBuilder(null, null, field.getFieldType());
                        }
                        if (oldTrieBuilder.getValue() != null && !((Type)oldTrieBuilder.getValue()).isAny()) {
                            return oldTrieBuilder;
                        }
                        oldTrieBuilder.setValue(Type.any());
                        return oldTrieBuilder;
                    });
                }
                resultTrieBuilders.add(currentTrieBuilder);
            }
            return resultTrieBuilders.build();
        }
        if (derivationValue instanceof FirstOrDefaultValue || derivationValue instanceof FirstOrDefaultStreamingValue) {
            Verify.verify(nestedResults.size() == 2);
            return (List)nestedResults.get(0);
        }
        if (derivationValue instanceof RecordConstructorValue) {
            CompatibleTypeEvolutionPredicate.terminateBuilders((ImmutableList<List<FieldAccessTrieNodeBuilder>>)nestedResults, builder -> Type.any());
            return ImmutableList.of();
        }
        CompatibleTypeEvolutionPredicate.terminateBuilders((ImmutableList<List<FieldAccessTrieNodeBuilder>>)nestedResults, FieldAccessTrieNodeBuilder::getCurrentType);
        return ImmutableList.of();
    }

    private static void terminateBuilders(@Nonnull ImmutableList<List<FieldAccessTrieNodeBuilder>> nestedResults, Function<FieldAccessTrieNodeBuilder, Type> typeFunction) {
        for (List list : nestedResults) {
            for (FieldAccessTrieNodeBuilder nestedTrieBuilder : list) {
                nestedTrieBuilder.setValue(typeFunction.apply(nestedTrieBuilder));
            }
        }
    }

    public static boolean isAccessCompatibleWithCurrentType(@Nonnull FieldAccessTrieNode fieldAccessTrieNode, @Nonnull Type currentType) {
        if (fieldAccessTrieNode.getChildrenMap() != null) {
            while (currentType.isArray()) {
                currentType = Objects.requireNonNull(((Type.Array)currentType).getElementType());
            }
            Verify.verify(currentType.isRecord());
            Type.Record currentRecordType = (Type.Record)currentType;
            Map childrenMap = fieldAccessTrieNode.getChildrenMap();
            Map<String, Type.Record.Field> fieldNameFieldMap = currentRecordType.getFieldNameFieldMap();
            Map<String, Integer> fieldNameOrdinalMap = currentRecordType.getFieldNameToOrdinalMap();
            for (Map.Entry entry : childrenMap.entrySet()) {
                FieldValue.ResolvedAccessor resolvedAccessor = (FieldValue.ResolvedAccessor)entry.getKey();
                String name = resolvedAccessor.getName();
                Integer ordinalInCurrentRecordType = fieldNameOrdinalMap.get(name);
                if (ordinalInCurrentRecordType == null) {
                    return false;
                }
                if (ordinalInCurrentRecordType.intValue() != resolvedAccessor.getOrdinal()) {
                    return false;
                }
                Type.Record.Field fieldInCurrentRecordType = fieldNameFieldMap.get(name);
                if (CompatibleTypeEvolutionPredicate.isAccessCompatibleWithCurrentType((FieldAccessTrieNode)entry.getValue(), fieldInCurrentRecordType.getFieldType())) continue;
                return false;
            }
            return true;
        }
        Type type = Objects.requireNonNull((Type)fieldAccessTrieNode.getValue());
        if (type.isAny()) {
            return true;
        }
        return type.equals(currentType);
    }

    @Nonnull
    public static CompatibleTypeEvolutionPredicate fromPlan(@Nonnull RecordQueryPlan plannedPlan) {
        DerivationsProperty.Derivations derivations = DerivationsProperty.derivations().evaluate(plannedPlan);
        List<Value> simplifiedLocalValues = derivations.simplifyLocalValues();
        Map<String, FieldAccessTrieNode> fieldAccesses = CompatibleTypeEvolutionPredicate.computeFieldAccesses(simplifiedLocalValues);
        return new CompatibleTypeEvolutionPredicate(fieldAccesses);
    }

    public static class FieldAccessTrieNode
    extends TrieNode.AbstractTrieNode<FieldValue.ResolvedAccessor, Type, FieldAccessTrieNode>
    implements PlanHashable,
    PlanSerializable {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-Access-Trie-Node");

        private FieldAccessTrieNode(@Nullable Type type, @Nullable Map<FieldValue.ResolvedAccessor, FieldAccessTrieNode> childrenMap) {
            super(type, childrenMap);
        }

        @Override
        @Nonnull
        public FieldAccessTrieNode getThis() {
            return this;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getValue(), this.getChildrenMap());
        }

        @Nonnull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Map childrenMap = this.getChildrenMap();
            if (childrenMap != null) {
                int size = childrenMap.size();
                int i = 0;
                for (Map.Entry entry : childrenMap.entrySet()) {
                    builder.append("[").append(((FieldValue.ResolvedAccessor)entry.getKey()).toString()).append("]\u2192[").append(entry.getValue()).append("]");
                    if (i + 1 < size) {
                        builder.append(",");
                    }
                    ++i;
                }
            } else {
                builder.append(this.getValue());
            }
            return builder.toString();
        }

        @Override
        @Nonnull
        public PFieldAccessTrieNode toProto(@Nonnull PlanSerializationContext serializationContext) {
            PFieldAccessTrieNode.Builder builder = PFieldAccessTrieNode.newBuilder();
            Map childrenMap = this.getChildrenMap();
            builder.setChildrenMapIsNull(childrenMap == null);
            if (childrenMap != null) {
                for (Map.Entry entry : childrenMap.entrySet()) {
                    builder.addChildPair(PFieldAccessTrieNode.PResolvedAccessorChildPair.newBuilder().setResolvedAccessor(((FieldValue.ResolvedAccessor)entry.getKey()).toProto(serializationContext)).setChildFieldAccessTrieNode(((FieldAccessTrieNode)entry.getValue()).toProto(serializationContext)));
                }
            }
            if (this.getValue() != null) {
                builder.setType(((Type)this.getValue()).toTypeProto(serializationContext));
            }
            return builder.build();
        }

        @Nonnull
        public static FieldAccessTrieNode fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PFieldAccessTrieNode fieldAccessTrieNodeProto) {
            ImmutableMap<FieldValue.ResolvedAccessor, FieldAccessTrieNode> childrenMap;
            Verify.verify(fieldAccessTrieNodeProto.hasChildrenMapIsNull());
            if (fieldAccessTrieNodeProto.getChildrenMapIsNull()) {
                childrenMap = null;
            } else {
                ImmutableMap.Builder<FieldValue.ResolvedAccessor, FieldAccessTrieNode> childrenMapBuilder = ImmutableMap.builder();
                for (int i = 0; i < fieldAccessTrieNodeProto.getChildPairCount(); ++i) {
                    PFieldAccessTrieNode.PResolvedAccessorChildPair childPair = fieldAccessTrieNodeProto.getChildPair(i);
                    childrenMapBuilder.put(FieldValue.ResolvedAccessor.fromProto(serializationContext, Objects.requireNonNull(childPair.getResolvedAccessor())), FieldAccessTrieNode.fromProto(serializationContext, Objects.requireNonNull(childPair.getChildFieldAccessTrieNode())));
                }
                childrenMap = childrenMapBuilder.build();
            }
            Type type = fieldAccessTrieNodeProto.hasType() ? Type.fromTypeProto(serializationContext, fieldAccessTrieNodeProto.getType()) : null;
            return new FieldAccessTrieNode(type, (Map<FieldValue.ResolvedAccessor, FieldAccessTrieNode>)childrenMap);
        }

        @Nonnull
        public static FieldAccessTrieNode of(@Nonnull Type type, @Nullable Map<FieldValue.ResolvedAccessor, FieldAccessTrieNode> childrenMap) {
            return new FieldAccessTrieNode(type, childrenMap);
        }
    }

    public static class FieldAccessTrieNodeBuilder
    extends TrieNode.AbstractTrieNodeBuilder<FieldValue.ResolvedAccessor, Type, FieldAccessTrieNodeBuilder> {
        @Nonnull
        private final Type currentType;

        public FieldAccessTrieNodeBuilder(@Nonnull Type currentType) {
            this(null, null, currentType);
        }

        public FieldAccessTrieNodeBuilder(@Nullable Type type, @Nullable Map<FieldValue.ResolvedAccessor, FieldAccessTrieNodeBuilder> childrenMap, @Nonnull Type currentType) {
            super(type, childrenMap);
            this.currentType = currentType;
        }

        @Override
        @Nonnull
        public FieldAccessTrieNodeBuilder getThis() {
            return this;
        }

        @Nonnull
        public Type getCurrentType() {
            return this.currentType;
        }

        @Nonnull
        public FieldAccessTrieNode build() {
            if (this.getChildrenMap() != null) {
                ImmutableMap.Builder<FieldValue.ResolvedAccessor, FieldAccessTrieNode> childrenMapBuilder = ImmutableMap.builder();
                for (Map.Entry entry : this.getChildrenMap().entrySet()) {
                    childrenMapBuilder.put((FieldValue.ResolvedAccessor)entry.getKey(), ((FieldAccessTrieNodeBuilder)entry.getValue()).build());
                }
                return new FieldAccessTrieNode(null, childrenMapBuilder.build());
            }
            return new FieldAccessTrieNode(this.getCurrentType(), null);
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PCompatibleTypeEvolutionPredicate, CompatibleTypeEvolutionPredicate> {
        @Override
        @Nonnull
        public Class<PCompatibleTypeEvolutionPredicate> getProtoMessageClass() {
            return PCompatibleTypeEvolutionPredicate.class;
        }

        @Override
        @Nonnull
        public CompatibleTypeEvolutionPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCompatibleTypeEvolutionPredicate compatibleTypeEvolutionPredicateProto) {
            return CompatibleTypeEvolutionPredicate.fromProto(serializationContext, compatibleTypeEvolutionPredicateProto);
        }
    }
}

