/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PConstantPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ConstantPredicate
extends AbstractQueryPredicate
implements LeafQueryPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Constant-Predicate");
    @Nonnull
    public static final ConstantPredicate TRUE = new ConstantPredicate((Boolean)true);
    @Nonnull
    public static final ConstantPredicate FALSE = new ConstantPredicate((Boolean)false);
    @Nonnull
    public static final ConstantPredicate NULL = new ConstantPredicate(null);
    @Nullable
    private final Boolean value;

    public ConstantPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantPredicate constantPredicateProto) {
        super(serializationContext, Objects.requireNonNull(constantPredicateProto.getSuper()));
        this.value = constantPredicateProto.hasValue() ? Boolean.valueOf(constantPredicateProto.getValue()) : null;
    }

    public ConstantPredicate(@Nullable Boolean value) {
        super(false);
        this.value = value;
    }

    @Override
    public boolean isTautology() {
        return this.value != null && this.value != false;
    }

    @Override
    public boolean isContradiction() {
        return this.value != null && this.value == false;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.value;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public QueryPredicate translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        return this;
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return LeafQueryPredicate.super.equalsWithoutChildren(other, valueEquivalence).filter(ignored -> {
            ConstantPredicate that = (ConstantPredicate)other;
            return Objects.equals(this.value, that.value);
        });
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return LeafQueryPredicate.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(this.value);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.value);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addToString(this.value));
    }

    @Override
    @Nonnull
    public PConstantPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        PConstantPredicate.Builder builder = PConstantPredicate.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext));
        if (this.value != null) {
            builder.setValue(this.value);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setConstantPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ConstantPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantPredicate constantPredicateProto) {
        return new ConstantPredicate(serializationContext, constantPredicateProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PConstantPredicate, ConstantPredicate> {
        @Override
        @Nonnull
        public Class<PConstantPredicate> getProtoMessageClass() {
            return PConstantPredicate.class;
        }

        @Override
        @Nonnull
        public ConstantPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConstantPredicate constantPredicateProto) {
            return ConstantPredicate.fromProto(serializationContext, constantPredicateProto);
        }
    }
}

