/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.planprotos.PDatabaseObjectDependenciesPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class DatabaseObjectDependenciesPredicate
extends AbstractQueryPredicate
implements LeafQueryPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Database-Object-Dependencies-Predicate");
    @Nonnull
    private final Set<UsedIndex> usedIndexes;

    private DatabaseObjectDependenciesPredicate(@Nonnull Set<UsedIndex> usedIndexes) {
        super(true);
        this.usedIndexes = ImmutableSet.copyOf(usedIndexes);
    }

    @Nonnull
    public Set<UsedIndex> getUsedIndexes() {
        return this.usedIndexes;
    }

    @Override
    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        RecordMetaData recordMetaData = Objects.requireNonNull(store).getRecordMetaData();
        for (UsedIndex usedIndex : this.usedIndexes) {
            if (!recordMetaData.hasIndex(usedIndex.getName())) {
                return false;
            }
            Index currentIndex = recordMetaData.getIndex(usedIndex.getName());
            if (usedIndex.getLastModifiedVersion() != currentIndex.getLastModifiedVersion()) {
                return false;
            }
            RecordStoreState recordStoreState = store.getRecordStoreState();
            if (recordStoreState.isReadable(currentIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeSemanticHashCode() {
        return LeafQueryPredicate.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return PlanHashable.objectsPlanHash(PlanHashable.CURRENT_FOR_CONTINUATION, BASE_HASH, super.hashCodeWithoutChildren(), this.usedIndexes);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.isAtomic(), this.usedIndexes);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("databaseObjectDependencies"));
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return super.equalsWithoutChildren(other, valueEquivalence).filter(ignored -> {
            DatabaseObjectDependenciesPredicate otherDatabaseObjectDependenciesPredicate = (DatabaseObjectDependenciesPredicate)other;
            return this.usedIndexes.equals(otherDatabaseObjectDependenciesPredicate.usedIndexes);
        });
    }

    @Override
    @Nonnull
    public PDatabaseObjectDependenciesPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        PDatabaseObjectDependenciesPredicate.Builder builder = PDatabaseObjectDependenciesPredicate.newBuilder();
        for (UsedIndex usedIndex : this.usedIndexes) {
            builder.addUsedIndexes(usedIndex.toProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setDatabaseObjectDependenciesPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static DatabaseObjectDependenciesPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PDatabaseObjectDependenciesPredicate databaseObjectDependenciesPredicateProto) {
        ImmutableSet.Builder usedIndexesBuilder = ImmutableSet.builder();
        for (int i = 0; i < databaseObjectDependenciesPredicateProto.getUsedIndexesCount(); ++i) {
            PDatabaseObjectDependenciesPredicate.PUsedIndex usedIndexProto = databaseObjectDependenciesPredicateProto.getUsedIndexes(i);
            usedIndexesBuilder.add(UsedIndex.fromProto(serializationContext, usedIndexProto));
        }
        return new DatabaseObjectDependenciesPredicate((Set<UsedIndex>)((Object)usedIndexesBuilder.build()));
    }

    @Nonnull
    public static DatabaseObjectDependenciesPredicate fromPlan(@Nonnull RecordMetaData recordMetaData, @Nonnull RecordQueryPlan plan) {
        ArrayList<String> usedIndexesNamesList = Lists.newArrayList(plan.getUsedIndexes());
        Collections.sort(usedIndexesNamesList);
        ImmutableSet.Builder usedIndexesBuilder = ImmutableSet.builder();
        for (String usedIndexName : usedIndexesNamesList) {
            Index index = recordMetaData.getIndex(usedIndexName);
            usedIndexesBuilder.add(new UsedIndex(usedIndexName, index.getLastModifiedVersion()));
        }
        return new DatabaseObjectDependenciesPredicate((Set<UsedIndex>)((Object)usedIndexesBuilder.build()));
    }

    public static class UsedIndex
    implements PlanHashable,
    PlanSerializable {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Used-Index");
        @Nonnull
        private final String name;
        private final int lastModifiedVersion;

        public UsedIndex(@Nonnull String name, int lastModifiedVersion) {
            this.name = name;
            this.lastModifiedVersion = lastModifiedVersion;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public int getLastModifiedVersion() {
            return this.lastModifiedVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsedIndex)) {
                return false;
            }
            UsedIndex usedIndex = (UsedIndex)o;
            return this.lastModifiedVersion == usedIndex.lastModifiedVersion && Objects.equals(this.name, usedIndex.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.lastModifiedVersion);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.name, this.lastModifiedVersion);
        }

        @Override
        @Nonnull
        public PDatabaseObjectDependenciesPredicate.PUsedIndex toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PDatabaseObjectDependenciesPredicate.PUsedIndex.newBuilder().setName(this.name).setLastModifiedVersion(this.lastModifiedVersion).build();
        }

        @Nonnull
        public static UsedIndex fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PDatabaseObjectDependenciesPredicate.PUsedIndex usedIndexProto) {
            return new UsedIndex(usedIndexProto.getName(), usedIndexProto.getLastModifiedVersion());
        }
    }

    public static class Deserializer
    implements PlanDeserializer<PDatabaseObjectDependenciesPredicate, DatabaseObjectDependenciesPredicate> {
        @Override
        @Nonnull
        public Class<PDatabaseObjectDependenciesPredicate> getProtoMessageClass() {
            return PDatabaseObjectDependenciesPredicate.class;
        }

        @Override
        @Nonnull
        public DatabaseObjectDependenciesPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PDatabaseObjectDependenciesPredicate databaseObjectDependenciesPredicateProto) {
            return DatabaseObjectDependenciesPredicate.fromProto(serializationContext, databaseObjectDependenciesPredicateProto);
        }
    }
}

