/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PExistsPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.EXPERIMENTAL)
public class ExistsPredicate
extends AbstractQueryPredicate
implements LeafQueryPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Exists-Predicate");
    @Nonnull
    private final CorrelationIdentifier existentialAlias;

    private ExistsPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PExistsPredicate existsPredicateProto) {
        super(serializationContext, Objects.requireNonNull(existsPredicateProto.getSuper()));
        this.existentialAlias = CorrelationIdentifier.of(Objects.requireNonNull(existsPredicateProto.getExistentialAlias()));
    }

    public ExistsPredicate(@Nonnull CorrelationIdentifier existentialAlias) {
        super(false);
        this.existentialAlias = existentialAlias;
    }

    @Nonnull
    public CorrelationIdentifier getExistentialAlias() {
        return this.existentialAlias;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        throw new RecordCoreException("this predicate cannot be evaluated per record", new Object[0]);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        resultBuilder.add(this.existentialAlias);
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public ExistsPredicate translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        QuantifiedObjectValue translatedQuantifiedObjectValue;
        QuantifiedObjectValue quantifiedObjectValue = QuantifiedObjectValue.of(this.existentialAlias, Type.any());
        if (quantifiedObjectValue == (translatedQuantifiedObjectValue = (QuantifiedObjectValue)quantifiedObjectValue.translateCorrelations(translationMap))) {
            return this;
        }
        return new ExistsPredicate(translatedQuantifiedObjectValue.getAlias());
    }

    @Override
    @Nonnull
    public QueryPredicate toResidualPredicate() {
        return new ValuePredicate(QuantifiedObjectValue.of(this.existentialAlias, new Type.Any()), new Comparisons.NullComparison(Comparisons.Type.NOT_NULL));
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return LeafQueryPredicate.super.equalsWithoutChildren(other, valueEquivalence).compose(ignored -> {
            ExistsPredicate that = (ExistsPredicate)other;
            if (this.existentialAlias.equals(that.existentialAlias)) {
                return ConstrainedBoolean.alwaysTrue();
            }
            return valueEquivalence.isDefinedEqual(this.existentialAlias, that.existentialAlias);
        });
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return LeafQueryPredicate.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return this.planHash(PlanHashable.CURRENT_FOR_CONTINUATION);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public Optional<PredicateMultiMap.PredicateMapping> impliesCandidatePredicateMaybe(@NonNull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull EvaluationContext evaluationContext) {
        if (!(candidatePredicate instanceof Placeholder) && candidatePredicate.isTautology()) {
            return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation(this.getDefaultPredicateCompensation(originalQueryPredicate)).build());
        }
        return super.impliesCandidatePredicateMaybe(valueEquivalence, originalQueryPredicate, candidatePredicate, evaluationContext);
    }

    @Override
    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull List<PredicateMultiMap.PredicateCompensationFunction> childrenResults, @Nonnull PullUp pullUp) {
        Verify.verify(childrenResults.isEmpty());
        return this.computeCompensationFunction(partialMatch, (ExistsPredicate)originalQueryPredicate, boundParameterPrefixMap);
    }

    @Nonnull
    private PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull ExistsPredicate originalExistsPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap) {
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        Optional<PartialMatch> childPartialMatchOptional = regularMatchInfo.getChildPartialMatchMaybe(originalExistsPredicate.getExistentialAlias());
        Optional<Compensation> compensationOptional = childPartialMatchOptional.map(childPartialMatch -> childPartialMatch.compensateExistential(boundParameterPrefixMap));
        if (compensationOptional.isEmpty() || compensationOptional.get().isNeededForFiltering()) {
            return PredicateMultiMap.PredicateCompensationFunction.ofExistentialPredicate(originalExistsPredicate);
        }
        return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
    }

    @Override
    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunctionForLeaf(@Nonnull PullUp pullUp) {
        throw new RecordCoreException("this should not be called", new Object[0]);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword("\u2203").addAliasReference(this.existentialAlias));
    }

    @Override
    @Nonnull
    public PExistsPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PExistsPredicate.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext)).setExistentialAlias(this.existentialAlias.getId()).build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setExistsPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ExistsPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PExistsPredicate existsPredicateProto) {
        return new ExistsPredicate(serializationContext, existsPredicateProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PExistsPredicate, ExistsPredicate> {
        @Override
        @Nonnull
        public Class<PExistsPredicate> getProtoMessageClass() {
            return PExistsPredicate.class;
        }

        @Override
        @Nonnull
        public ExistsPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PExistsPredicate existsPredicateProto) {
            return ExistsPredicate.fromProto(serializationContext, existsPredicateProto);
        }
    }
}

