/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PNotPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicateWithChild;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class NotPredicate
extends AbstractQueryPredicate
implements QueryPredicateWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Not-Predicate");
    @Nonnull
    public final QueryPredicate child;

    private NotPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNotPredicate notPredicateProto) {
        super(serializationContext, Objects.requireNonNull(notPredicateProto.getSuper()));
        this.child = QueryPredicate.fromQueryPredicateProto(serializationContext, Objects.requireNonNull(notPredicateProto.getChild()));
    }

    private NotPredicate(@Nonnull QueryPredicate child, boolean isAtomic) {
        super(isAtomic);
        this.child = child;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.invert(this.child.eval(store, context));
    }

    @Nullable
    private Boolean invert(@Nullable Boolean v) {
        if (v == null) {
            return null;
        }
        return v == false;
    }

    @Override
    @Nonnull
    public QueryPredicate getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.NOT, new ExplainTokens().addKeyword("NOT").addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.NOT.parenthesizeChild(Iterables.getOnlyElement(explainSuppliers).get())));
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return Objects.hash(this.hashCodeWithoutChildren(), this.getChild());
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.planHash(PlanHashable.CURRENT_FOR_CONTINUATION), super.hashCodeWithoutChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getChild().planHash(mode) + 1;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public NotPredicate withChild(@Nonnull QueryPredicate newChild) {
        return new NotPredicate(newChild, this.isAtomic());
    }

    @Override
    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull List<PredicateMultiMap.PredicateCompensationFunction> childrenCompensationFunctions, @Nonnull PullUp pullUp) {
        Verify.verify(childrenCompensationFunctions.size() == 1);
        PredicateMultiMap.PredicateCompensationFunction predicateCompensationFunction = Iterables.getOnlyElement(childrenCompensationFunctions);
        if (!predicateCompensationFunction.isNeeded()) {
            return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
        }
        return PredicateMultiMap.PredicateCompensationFunction.ofChildrenCompensationFunctions(childrenCompensationFunctions, (functions, baseAlias) -> {
            Set<QueryPredicate> childPredicates = ((PredicateMultiMap.PredicateCompensationFunction)Iterables.getOnlyElement(functions)).applyCompensationForPredicate((TranslationMap)baseAlias);
            return LinkedIdentitySet.of(new QueryPredicate[]{NotPredicate.not(AndPredicate.and(childPredicates))});
        });
    }

    @Override
    @Nonnull
    public NotPredicate withAtomicity(boolean isAtomic) {
        return new NotPredicate(this.getChild(), isAtomic);
    }

    @Override
    @Nonnull
    public PNotPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PNotPredicate.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext)).setChild(this.child.toQueryPredicateProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setNotPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static NotPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNotPredicate notPredicateProto) {
        return new NotPredicate(serializationContext, notPredicateProto);
    }

    @Nonnull
    public static NotPredicate not(@Nonnull QueryPredicate predicate) {
        return NotPredicate.of(predicate, false);
    }

    @Nonnull
    public static NotPredicate of(@Nonnull QueryPredicate predicate, boolean isAtomic) {
        return new NotPredicate(predicate, isAtomic);
    }

    public static class Deserializer
    implements PlanDeserializer<PNotPredicate, NotPredicate> {
        @Override
        @Nonnull
        public Class<PNotPredicate> getProtoMessageClass() {
            return PNotPredicate.class;
        }

        @Override
        @Nonnull
        public NotPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNotPredicate notPredicateProto) {
            return NotPredicate.fromProto(serializationContext, notPredicateProto);
        }
    }
}

