/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.POrPredicate;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.LeafQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Proposition;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ComparisonCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.EXPERIMENTAL)
public class OrPredicate
extends AndOrPredicate {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Or-Predicate");

    private OrPredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull POrPredicate orPredicateProto) {
        super(serializationContext, Objects.requireNonNull(orPredicateProto.getSuper()));
    }

    private OrPredicate(@Nonnull List<? extends QueryPredicate> operands, boolean isAtomic) {
        super(operands, isAtomic);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        Boolean defaultValue = Boolean.FALSE;
        for (QueryPredicate child : this.getChildren()) {
            Boolean val = child.eval(store, context);
            if (val == null) {
                defaultValue = null;
                continue;
            }
            if (!val.booleanValue()) continue;
            return true;
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.OR, new ExplainTokens().addSequence(() -> new ExplainTokens().addWhitespace().addKeyword("OR").addWhitespace(), () -> Streams.stream(explainSuppliers).map(Supplier::get).map(ExplainTokensWithPrecedence.Precedence.OR::parenthesizeChild).iterator()));
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(BASE_HASH.planHash(PlanHashable.CURRENT_FOR_CONTINUATION), super.hashCodeWithoutChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                ArrayList<ObjectPlanHash> hashables = new ArrayList<ObjectPlanHash>(this.getChildren().size() + 1);
                hashables.add(BASE_HASH);
                hashables.addAll((Collection<ObjectPlanHash>)this.getChildren());
                return PlanHashable.planHashUnordered(mode, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public OrPredicate withChildren(Iterable<? extends QueryPredicate> newChildren) {
        return new OrPredicate(ImmutableList.copyOf(newChildren), this.isAtomic());
    }

    @Override
    @Nonnull
    public Optional<PredicateWithValueAndRanges> toValueWithRangesMaybe(@Nonnull EvaluationContext evaluationContext) {
        if (!this.getChildren().stream().allMatch(child -> child instanceof PredicateWithValue)) {
            return Optional.empty();
        }
        if (this.getChildren().stream().map(c -> ((PredicateWithValue)c).getValue()).distinct().count() > 1L) {
            return Optional.empty();
        }
        ImmutableSet.Builder rangesSet = ImmutableSet.builder();
        for (QueryPredicate child2 : this.getChildren()) {
            RangeConstraints.Builder rangesBuilder = RangeConstraints.newBuilder();
            if (child2 instanceof ValuePredicate) {
                ValuePredicate valuePredicate = (ValuePredicate)child2;
                if (!rangesBuilder.addComparisonMaybe(valuePredicate.getComparison())) {
                    return Optional.empty();
                }
            } else if (child2 instanceof PredicateWithValueAndRanges) {
                rangesSet.addAll(((PredicateWithValueAndRanges)child2).getRanges());
            } else {
                return Optional.empty();
            }
            Optional<RangeConstraints> range = rangesBuilder.build();
            if (range.isEmpty()) {
                return Optional.empty();
            }
            rangesSet.add(range.get());
        }
        Value value = Objects.requireNonNull(((PredicateWithValue)Iterables.getFirst(this.getChildren(), null)).getValue());
        return Optional.of(PredicateWithValueAndRanges.ofRanges(value, (Set<RangeConstraints>)((Object)rangesSet.build())));
    }

    @Override
    @Nonnull
    public Optional<PredicateMultiMap.PredicateMapping> impliesCandidatePredicateMaybe(@NonNull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull EvaluationContext evaluationContext) {
        Optional<PredicateMultiMap.PredicateMapping> mappingsOptional = super.impliesCandidatePredicateMaybe(valueEquivalence, originalQueryPredicate, candidatePredicate, evaluationContext);
        if (mappingsOptional.isPresent()) {
            return mappingsOptional;
        }
        Optional<PredicateWithValueAndRanges> valueWithRangesOptional = this.toValueWithRangesMaybe(evaluationContext);
        if (valueWithRangesOptional.isPresent()) {
            PredicateWithValueAndRanges leftValueWithRanges = valueWithRangesOptional.get();
            Optional<PredicateWithValueAndRanges> candidateValueWithRangesOptional = candidatePredicate.toValueWithRangesMaybe(evaluationContext);
            if (candidateValueWithRangesOptional.isPresent()) {
                PredicateWithValueAndRanges rightValueWithRanges = candidateValueWithRangesOptional.get();
                mappingsOptional = this.impliesWithValuesAndRanges(valueEquivalence, originalQueryPredicate, candidatePredicate, evaluationContext, leftValueWithRanges, rightValueWithRanges);
            }
        }
        if (mappingsOptional.isEmpty() && candidatePredicate instanceof Placeholder) {
            Value candidateValue = ((Placeholder)candidatePredicate).getValue();
            Optional constraintOptional = this.preOrderStream().filter(LeafQueryPredicate.class::isInstance).flatMap(predicate -> {
                if (predicate instanceof PredicateWithValue) {
                    Value queryValue = ((ValuePredicate)predicate).getValue();
                    return queryValue.matchAndCompensateComparisonMaybe(candidateValue, valueEquivalence).map(Pair::getValue).stream();
                }
                return Stream.empty();
            }).findFirst();
            if (constraintOptional.isPresent()) {
                return Optional.of(PredicateMultiMap.PredicateMapping.orTermMappingBuilder(originalQueryPredicate, this, new ConstantPredicate((Boolean)true)).setPredicateCompensation(this.getDefaultPredicateCompensation(originalQueryPredicate)).setConstraint((QueryPlanConstraint)constraintOptional.get()).build());
            }
        }
        return mappingsOptional;
    }

    @Nonnull
    private Optional<PredicateMultiMap.PredicateMapping> impliesWithValuesAndRanges(@Nonnull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull EvaluationContext evaluationContext, @Nonnull PredicateWithValueAndRanges leftValueWithRanges, @Nonnull PredicateWithValueAndRanges rightValueWithRanges) {
        Optional<NonnullPair<ComparisonCompensation, QueryPlanConstraint>> matchPairOptional = leftValueWithRanges.getValue().matchAndCompensateComparisonMaybe(rightValueWithRanges.getValue(), valueEquivalence);
        if (matchPairOptional.isEmpty()) {
            return Optional.empty();
        }
        NonnullPair<ComparisonCompensation, QueryPlanConstraint> matchPair = matchPairOptional.get();
        ComparisonCompensation comparisonCompensation = matchPair.getLeft();
        Optional<PredicateWithValueAndRanges> compensatedLeftValueWithRangesOptional = leftValueWithRanges.translateValueAndComparisonsMaybe(value -> Optional.of(comparisonCompensation.applyToValue((Value)value)), comparisonCompensation::applyToComparisonMaybe);
        if (compensatedLeftValueWithRangesOptional.isEmpty()) {
            return Optional.empty();
        }
        PredicateWithValueAndRanges compensatedLeftValueWithRanges = compensatedLeftValueWithRangesOptional.get();
        boolean requiresCompensation = false;
        for (RangeConstraints leftRange : compensatedLeftValueWithRanges.getRanges()) {
            boolean termRequiresCompensation = true;
            boolean foundMatch = false;
            for (RangeConstraints rightRange : rightValueWithRanges.getRanges()) {
                RangeConstraints evaluatedLeft;
                if (rightRange.encloses(evaluatedLeft = leftRange.compileTimeEval(evaluationContext), evaluationContext) != Proposition.TRUE) continue;
                foundMatch = true;
                if (evaluatedLeft.encloses(rightRange, evaluationContext) != Proposition.TRUE) continue;
                termRequiresCompensation = false;
                break;
            }
            if (!foundMatch) {
                return Optional.empty();
            }
            requiresCompensation = requiresCompensation || termRequiresCompensation;
        }
        if (requiresCompensation) {
            return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation(this.getDefaultPredicateCompensation(originalQueryPredicate)).build());
        }
        return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setConstraint(matchPair.getRight()).build());
    }

    @Override
    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull List<PredicateMultiMap.PredicateCompensationFunction> childrenCompensationFunctions, @Nonnull PullUp pullUp) {
        boolean isNeeded = false;
        for (PredicateMultiMap.PredicateCompensationFunction childPredicateCompensationFunction : childrenCompensationFunctions) {
            isNeeded |= childPredicateCompensationFunction.isNeeded();
            if (!childPredicateCompensationFunction.isImpossible()) continue;
            return PredicateMultiMap.PredicateCompensationFunction.impossibleCompensation();
        }
        if (!isNeeded) {
            return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
        }
        return PredicateMultiMap.PredicateCompensationFunction.ofChildrenCompensationFunctions(childrenCompensationFunctions, (functions, baseAlias) -> {
            ImmutableList childPredicatesList = functions.stream().filter(PredicateMultiMap.PredicateCompensationFunction::isNeeded).map(predicateCompensationFunction -> predicateCompensationFunction.applyCompensationForPredicate((TranslationMap)baseAlias)).collect(ImmutableList.toImmutableList());
            LinkedIdentitySet<QueryPredicate> predicates = LinkedIdentitySet.of(new QueryPredicate[0]);
            for (Set childPredicates : childPredicatesList) {
                predicates.add(AndPredicate.and(childPredicates));
            }
            return LinkedIdentitySet.of(new QueryPredicate[]{OrPredicate.or(predicates)});
        });
    }

    @Override
    @Nonnull
    public OrPredicate withAtomicity(boolean isAtomic) {
        return new OrPredicate(ImmutableList.copyOf(this.getChildren()), isAtomic);
    }

    @Override
    @Nonnull
    public POrPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        return POrPredicate.newBuilder().setSuper(this.toAndOrPredicateProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setOrPredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static OrPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POrPredicate orPredicateProto) {
        return new OrPredicate(serializationContext, orPredicateProto);
    }

    @Nonnull
    public static QueryPredicate or(@Nonnull QueryPredicate first, @Nonnull QueryPredicate second, QueryPredicate ... operands) {
        return OrPredicate.of(OrPredicate.toList(first, second, operands), false);
    }

    @Nonnull
    public static QueryPredicate or(@Nonnull Collection<? extends QueryPredicate> children) {
        return OrPredicate.of(children, false);
    }

    @Nonnull
    public static QueryPredicate orOrTrue(@Nonnull Collection<? extends QueryPredicate> disjuncts) {
        if (disjuncts.isEmpty()) {
            return ConstantPredicate.TRUE;
        }
        return OrPredicate.of(disjuncts, false);
    }

    @Nonnull
    public static QueryPredicate orOrFalse(@Nonnull Collection<? extends QueryPredicate> disjuncts) {
        if (disjuncts.isEmpty()) {
            return ConstantPredicate.FALSE;
        }
        return OrPredicate.of(disjuncts, false);
    }

    @Nonnull
    public static QueryPredicate of(@Nonnull Collection<? extends QueryPredicate> disjuncts, boolean isAtomic) {
        Verify.verify(!disjuncts.isEmpty());
        if (disjuncts.size() == 1) {
            return Iterables.getOnlyElement(disjuncts);
        }
        return new OrPredicate(ImmutableList.copyOf(disjuncts), isAtomic);
    }

    public static class Deserializer
    implements PlanDeserializer<POrPredicate, OrPredicate> {
        @Override
        @Nonnull
        public Class<POrPredicate> getProtoMessageClass() {
            return POrPredicate.class;
        }

        @Override
        @Nonnull
        public OrPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POrPredicate orPredicateProto) {
            return OrPredicate.fromProto(serializationContext, orPredicateProto);
        }
    }
}

