/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PPredicateWithValueAndRanges;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.WithAlias;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class Placeholder
extends PredicateWithValueAndRanges
implements WithAlias {
    @Nonnull
    private final CorrelationIdentifier parameterAlias;

    private Placeholder(@Nonnull Value value, @Nonnull Set<RangeConstraints> ranges, @Nonnull CorrelationIdentifier alias) {
        super(value, ranges);
        this.parameterAlias = alias;
    }

    @Override
    @Nonnull
    public PredicateWithValueAndRanges withValue(@Nonnull Value value) {
        return new Placeholder(value, this.getRanges(), this.parameterAlias);
    }

    @Override
    @Nonnull
    public PredicateWithValueAndRanges withRanges(@Nonnull Set<RangeConstraints> ranges) {
        return new Placeholder(this.getValue(), ranges, this.parameterAlias);
    }

    @Override
    public boolean isSargable() {
        return false;
    }

    @Override
    public boolean isTautology() {
        return !this.isConstraining();
    }

    @Nonnull
    public static Placeholder newInstanceWithoutRanges(@Nonnull Value value, @Nonnull CorrelationIdentifier parameterAlias) {
        return new Placeholder(value, ImmutableSet.of(), parameterAlias);
    }

    public boolean isConstraining() {
        return this.getRanges().stream().anyMatch(RangeConstraints::isConstraining);
    }

    @Override
    @Nonnull
    public Placeholder withValueAndRanges(@Nonnull Value value, @Nonnull Set<RangeConstraints> ranges) {
        return new Placeholder(value, ranges, this.parameterAlias);
    }

    @Nonnull
    public Placeholder withExtraRanges(@Nonnull Set<RangeConstraints> ranges) {
        return new Placeholder(this.getValue(), Stream.concat(ranges.stream(), this.getRanges().stream()).collect(ImmutableSet.toImmutableSet()), this.getParameterAlias());
    }

    @Override
    @Nonnull
    public Placeholder translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        return new Placeholder(this.getValue().translateCorrelations(translationMap), this.getRanges().stream().map(range -> range.translateCorrelations(translationMap, shouldSimplifyValues)).collect(ImmutableSet.toImmutableSet()), this.getParameterAlias());
    }

    @Override
    @Nonnull
    public CorrelationIdentifier getParameterAlias() {
        return this.parameterAlias;
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return super.equalsWithoutChildren(other, valueEquivalence).filter(ignored -> Objects.equals(this.parameterAlias, ((Placeholder)other).parameterAlias));
    }

    @Override
    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        if (!super.semanticEquals(other, AliasMap.emptyMap())) {
            return false;
        }
        if (!(other instanceof Placeholder)) {
            return false;
        }
        return this.parameterAlias.equals(((Placeholder)other).parameterAlias);
    }

    @Override
    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(super.explain(explainSuppliers).getExplainTokens().addWhitespace().addToString("->").addWhitespace().addIdentifier(this.getParameterAlias().toString()));
    }

    @Override
    @Nonnull
    public PPredicateWithValueAndRanges toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("call unsupported", new Object[0]);
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("call unsupported", new Object[0]);
    }
}

