/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PPredicateWithValueAndRanges;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.WithAlias;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.ComparisonCompensation;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.EXPERIMENTAL)
public class PredicateWithValueAndRanges
extends AbstractQueryPredicate
implements PredicateWithValue,
PredicateWithComparisons {
    @Nonnull
    private final Value value;
    @Nonnull
    private final Set<RangeConstraints> ranges;
    @Nonnull
    private final Supplier<Boolean> rangesCompileTimeChecker;

    protected PredicateWithValueAndRanges(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPredicateWithValueAndRanges predicateWithValueAndRangesProto) {
        super(serializationContext, Objects.requireNonNull(predicateWithValueAndRangesProto.getSuper()));
        this.value = Value.fromValueProto(serializationContext, Objects.requireNonNull(predicateWithValueAndRangesProto.getValue()));
        ImmutableSet.Builder rangeConstraintsBuilder = ImmutableSet.builder();
        for (int i = 0; i < predicateWithValueAndRangesProto.getRangesCount(); ++i) {
            rangeConstraintsBuilder.add(RangeConstraints.fromProto(serializationContext, predicateWithValueAndRangesProto.getRanges(i)));
        }
        this.ranges = rangeConstraintsBuilder.build();
        this.rangesCompileTimeChecker = () -> this.ranges.stream().allMatch(RangeConstraints::isCompileTime);
    }

    protected PredicateWithValueAndRanges(@Nonnull Value value, @Nonnull Set<RangeConstraints> ranges) {
        super(false);
        this.value = value;
        this.ranges = ImmutableSet.copyOf(ranges);
        this.rangesCompileTimeChecker = () -> ranges.stream().allMatch(RangeConstraints::isCompileTime);
    }

    @Override
    @Nonnull
    public Value getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public PredicateWithValueAndRanges withValue(@Nonnull Value value) {
        return new PredicateWithValueAndRanges(value, this.ranges);
    }

    @Nonnull
    public PredicateWithValueAndRanges withRanges(@Nonnull Set<RangeConstraints> ranges) {
        return new PredicateWithValueAndRanges(this.value, ranges);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        return Streams.concat(this.value.getCorrelatedTo().stream(), this.ranges.stream().flatMap(r -> r.getCorrelatedTo().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public List<Comparisons.Comparison> getComparisons() {
        return this.ranges.stream().flatMap(range -> range.getComparisons().stream()).collect(ImmutableList.toImmutableList());
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return PredicateWithValue.super.equalsWithoutChildren(other, valueEquivalence).compose(ignored -> {
            PredicateWithValueAndRanges that = (PredicateWithValueAndRanges)other;
            return this.value.semanticEquals((Object)that.value, valueEquivalence);
        }).compose(ignored -> {
            PredicateWithValueAndRanges that = (PredicateWithValueAndRanges)other;
            return valueEquivalence.semanticEquals(this.ranges, that.ranges);
        });
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return PredicateWithValue.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return this.value.semanticHashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        throw new RecordCoreException("this method should not ever be reached", new Object[0]);
    }

    @Nonnull
    public Set<RangeConstraints> getRanges() {
        return this.ranges;
    }

    public boolean isSargable() {
        return this.ranges.size() == 1;
    }

    @Override
    @Nonnull
    public PredicateWithValueAndRanges translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        return new PredicateWithValueAndRanges(this.value.translateCorrelations(translationMap, shouldSimplifyValues), this.ranges.stream().map(range -> range.translateCorrelations(translationMap, shouldSimplifyValues)).collect(ImmutableSet.toImmutableSet()));
    }

    @Nonnull
    public static PredicateWithValueAndRanges sargable(@Nonnull Value value, @Nonnull RangeConstraints range) {
        return new PredicateWithValueAndRanges(value, ImmutableSet.of(range));
    }

    @Nonnull
    public static PredicateWithValueAndRanges ofRanges(@Nonnull Value value, @Nonnull Set<RangeConstraints> ranges) {
        return new PredicateWithValueAndRanges(value, ranges);
    }

    @Nonnull
    public Optional<PredicateWithValueAndRanges> translateValueAndComparisonsMaybe(@Nonnull Function<Value, Optional<Value>> valueTranslator, @Nonnull Function<Comparisons.Comparison, Optional<Comparisons.Comparison>> comparisonTranslator) {
        boolean allSame = true;
        Optional<Value> newValueOptional = Verify.verifyNotNull(valueTranslator.apply(this.getValue()));
        if (newValueOptional.isEmpty()) {
            return Optional.empty();
        }
        if (newValueOptional.get() != this.getValue()) {
            allSame = false;
        }
        Value newValue = newValueOptional.get();
        ImmutableSet.Builder newRangesBuilder = ImmutableSet.builder();
        for (RangeConstraints range : this.ranges) {
            Optional<RangeConstraints> newRangeOptional = range.translateRanges(comparisonTranslator);
            if (newRangeOptional.isEmpty()) {
                return Optional.empty();
            }
            if (newRangeOptional.get() != range) {
                allSame = false;
            }
            newRangesBuilder.add(newRangeOptional.get());
        }
        if (allSame) {
            return Optional.of(this);
        }
        return Optional.of(this.withValueAndRanges(newValue, (Set<RangeConstraints>)((Object)newRangesBuilder.build())));
    }

    @Nonnull
    public PredicateWithValueAndRanges withValueAndRanges(@Nonnull Value value, @Nonnull Set<RangeConstraints> ranges) {
        return new PredicateWithValueAndRanges(value, ranges);
    }

    @Override
    @Nonnull
    public Optional<PredicateMultiMap.PredicateMapping> impliesCandidatePredicateMaybe(@NonNull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull EvaluationContext evaluationContext) {
        if (candidatePredicate.isContradiction()) {
            return Optional.empty();
        }
        if (candidatePredicate instanceof PredicateWithValueAndRanges) {
            PredicateWithValueAndRanges candidatePredicateWithValuesAndRanges = (PredicateWithValueAndRanges)candidatePredicate;
            Optional<NonnullPair<ComparisonCompensation, QueryPlanConstraint>> matchPairOptional = this.getValue().matchAndCompensateComparisonMaybe(candidatePredicateWithValuesAndRanges.getValue(), valueEquivalence);
            if (matchPairOptional.isEmpty()) {
                return Optional.empty();
            }
            NonnullPair<ComparisonCompensation, QueryPlanConstraint> matchPair = matchPairOptional.get();
            ComparisonCompensation comparisonCompensation = matchPair.getLeft();
            QueryPlanConstraint constraint = matchPair.getRight();
            Optional<PredicateWithValueAndRanges> compensatedQueryPredicateOptional = this.translateValueAndComparisonsMaybe(v -> Optional.of(comparisonCompensation.applyToValue((Value)v)), comparisonCompensation::applyToComparisonMaybe);
            if (compensatedQueryPredicateOptional.isEmpty()) {
                return Optional.empty();
            }
            PredicateWithValueAndRanges compensatedQueryPredicate = compensatedQueryPredicateOptional.get();
            if (candidatePredicateWithValuesAndRanges.getRanges().isEmpty()) {
                if (candidatePredicateWithValuesAndRanges instanceof WithAlias) {
                    CorrelationIdentifier alias = ((WithAlias)((Object)candidatePredicateWithValuesAndRanges)).getParameterAlias();
                    PredicateMultiMap.PredicateMapping.Builder predicateMappingBuilder = PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation((ignore, boundParameterPrefixMap, pullUp) -> {
                        if (boundParameterPrefixMap.containsKey(alias)) {
                            return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
                        }
                        return this.computeCompensationFunctionForLeaf(pullUp);
                    }).setParameterAlias(alias).setConstraint(constraint);
                    Verify.verify(this.isSargable() == compensatedQueryPredicate.isSargable());
                    if (compensatedQueryPredicate.isSargable()) {
                        predicateMappingBuilder.setParameterAlias(alias);
                        predicateMappingBuilder.setComparisonRange(Iterables.getOnlyElement(compensatedQueryPredicate.getRanges()).asComparisonRange());
                    }
                    return Optional.of(predicateMappingBuilder.build());
                }
                return Optional.empty();
            }
            Set<RangeConstraints> candidateRanges = candidatePredicateWithValuesAndRanges.getRanges();
            if (compensatedQueryPredicate.getRanges().stream().allMatch(range -> candidateRanges.stream().anyMatch(candidateRange -> candidateRange.encloses((RangeConstraints)range, evaluationContext).coalesce()))) {
                if (candidatePredicateWithValuesAndRanges instanceof WithAlias) {
                    CorrelationIdentifier alias = ((WithAlias)((Object)candidatePredicateWithValuesAndRanges)).getParameterAlias();
                    PredicateMultiMap.PredicateMapping.Builder predicateMappingBuilder = PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation((ignore, boundParameterPrefixMap, pullUp) -> {
                        if (boundParameterPrefixMap.containsKey(alias)) {
                            return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
                        }
                        return this.computeCompensationFunctionForLeaf(pullUp);
                    }).setConstraint(constraint.compose(this.captureConstraint(candidatePredicateWithValuesAndRanges)));
                    Verify.verify(this.isSargable() == compensatedQueryPredicate.isSargable());
                    if (compensatedQueryPredicate.isSargable()) {
                        predicateMappingBuilder.setParameterAlias(alias);
                        predicateMappingBuilder.setComparisonRange(Iterables.getOnlyElement(compensatedQueryPredicate.getRanges()).asComparisonRange());
                    }
                    return Optional.of(predicateMappingBuilder.build());
                }
                return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation((ignore, alsoIgnore, pullUp) -> {
                    if (candidateRanges.stream().allMatch(candidateRange -> this.getRanges().stream().anyMatch(range -> range.encloses((RangeConstraints)candidateRange, evaluationContext).coalesce()))) {
                        return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
                    }
                    if (this.getRanges().stream().allMatch(left -> candidateRanges.stream().anyMatch(right -> left.semanticEquals(right, valueEquivalence).isTrue()))) {
                        return PredicateMultiMap.PredicateCompensationFunction.noCompensationNeeded();
                    }
                    return this.computeCompensationFunctionForLeaf(pullUp);
                }).setConstraint(constraint.compose(this.captureConstraint(candidatePredicateWithValuesAndRanges))).build());
            }
        }
        if (candidatePredicate.isTautology()) {
            return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation((ignore, alsoIgnore, pullUp) -> this.computeCompensationFunctionForLeaf(pullUp)).build());
        }
        ConstrainedBoolean semanticEquals = this.semanticEquals((Object)candidatePredicate, valueEquivalence);
        if (semanticEquals.isFalse()) {
            return Optional.empty();
        }
        return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setConstraint(semanticEquals.getConstraint()).build());
    }

    @Override
    @Nonnull
    public QueryPredicate toResidualPredicate() {
        ImmutableList.Builder dnfParts = ImmutableList.builder();
        for (RangeConstraints range : this.ranges) {
            ImmutableList.Builder residuals = ImmutableList.builder();
            residuals.addAll((Iterable)range.getComparisons().stream().map(c -> this.getValue().withComparison((Comparisons.Comparison)c)).collect(ImmutableList.toImmutableList()));
            dnfParts.add(AndPredicate.and(residuals.build()));
        }
        return OrPredicate.or(dnfParts.build());
    }

    @Override
    @Nonnull
    public Optional<PredicateWithValueAndRanges> toValueWithRangesMaybe(@Nonnull EvaluationContext evaluationContext) {
        return Optional.of(this.compileTimeEvalRanges(evaluationContext));
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        ExplainTokens resultExplainTokens = new ExplainTokens().addNested(this.getValue().explain().getExplainTokens());
        if (!this.ranges.isEmpty()) {
            resultExplainTokens.addWhitespace().addSequence(() -> new ExplainTokens().addWhitespace().addKeyword("OR").addWhitespace(), () -> this.ranges.stream().map(RangeConstraints::explain).map(ExplainTokensWithPrecedence.Precedence.OR::parenthesizeChild).iterator());
        }
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.ALWAYS_PARENS, resultExplainTokens);
    }

    @Nonnull
    private PredicateWithValueAndRanges compileTimeEvalRanges(@Nonnull EvaluationContext evaluationContext) {
        if (this.rangesCompileTimeChecker.get().booleanValue()) {
            return this;
        }
        ImmutableSet.Builder newRanges = ImmutableSet.builder();
        for (RangeConstraints range : this.ranges) {
            newRanges.add(range.compileTimeEval(evaluationContext));
        }
        return this.withValueAndRanges(this.value, (Set<RangeConstraints>)((Object)newRanges.build()));
    }

    @Nonnull
    private QueryPlanConstraint captureConstraint(@Nonnull PredicateWithValueAndRanges candidatePredicate) {
        Set candidateRanges = candidatePredicate.getRanges().stream().map(constraint -> {
            RangeConstraints.Builder builder = RangeConstraints.newBuilder();
            constraint.getComparisons().stream().map(PredicateWithValueAndRanges::exclusiveToInclusive).forEach(builder::addComparisonMaybe);
            return builder.build();
        }).flatMap(Optional::stream).collect(Collectors.toSet());
        ImmutableList.Builder conjunctions = ImmutableList.builder();
        for (RangeConstraints queryRange : this.getRanges()) {
            conjunctions.add(AndPredicate.and(queryRange.getComparisons().stream().filter(comparison -> comparison instanceof Comparisons.ValueComparison).map(valueComparison -> ((Comparisons.ValueComparison)valueComparison).getComparandValue()).map(constant -> PredicateWithValueAndRanges.ofRanges(constant, candidateRanges)).collect(Collectors.toList())));
        }
        QueryPredicate orPredicate = OrPredicate.or(conjunctions.build());
        return QueryPlanConstraint.ofPredicate(orPredicate);
    }

    @Nonnull
    private static Comparisons.Comparison exclusiveToInclusive(@Nonnull Comparisons.Comparison comparison) {
        switch (comparison.getType()) {
            case LESS_THAN: {
                return comparison.withType(Comparisons.Type.LESS_THAN_OR_EQUALS);
            }
            case GREATER_THAN: {
                return comparison.withType(Comparisons.Type.GREATER_THAN_OR_EQUALS);
            }
        }
        return comparison;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        if (!(this.value instanceof Value.RangeMatchableValue)) {
            throw new RecordCoreException("attempt to compile-time predicate with non-compile-time value.", new Object[0]);
        }
        Object valueObject = this.value.eval(store, context);
        if (valueObject == null) {
            return null;
        }
        RangeConstraints.Builder builder = RangeConstraints.newBuilder();
        builder.addComparisonMaybe(new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, valueObject));
        RangeConstraints valueRange = builder.build().orElseThrow();
        for (RangeConstraints range : this.getRanges()) {
            RangeConstraints compiledRange = range.compileTimeEval(context);
            if (!compiledRange.isCompileTimeEvaluable() || !compiledRange.encloses(valueRange, context).coalesce()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public PPredicateWithValueAndRanges toProto(@Nonnull PlanSerializationContext serializationContext) {
        PPredicateWithValueAndRanges.Builder builder = PPredicateWithValueAndRanges.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext)).setValue(this.value.toValueProto(serializationContext));
        for (RangeConstraints range : this.ranges) {
            builder.addRanges(range.toProto(serializationContext));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setPredicateWithValueAndRanges(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static PredicateWithValueAndRanges fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPredicateWithValueAndRanges predicateWithValueAndRangesProto) {
        return new PredicateWithValueAndRanges(serializationContext, predicateWithValueAndRangesProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PPredicateWithValueAndRanges, PredicateWithValueAndRanges> {
        @Override
        @Nonnull
        public Class<PPredicateWithValueAndRanges> getProtoMessageClass() {
            return PPredicateWithValueAndRanges.class;
        }

        @Override
        @Nonnull
        public PredicateWithValueAndRanges fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PPredicateWithValueAndRanges predicateWithValueAndRangesProto) {
            return PredicateWithValueAndRanges.fromProto(serializationContext, predicateWithValueAndRangesProto);
        }
    }
}

