/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Proposition {
    TRUE(Boolean.TRUE),
    FALSE(Boolean.FALSE),
    UNKNOWN(null){

        @Override
        public Proposition and(@Nonnull Proposition other) {
            return this;
        }

        @Override
        public Proposition or(@Nonnull Proposition other) {
            return this;
        }
    };

    @Nullable
    private final Boolean value;

    private Proposition(Boolean value) {
        this.value = value;
    }

    public Proposition and(@Nonnull Proposition other) {
        if (UNKNOWN == other) {
            return UNKNOWN;
        }
        return Proposition.of(Objects.requireNonNull(this.value) != false && Objects.requireNonNull(other.value) != false);
    }

    public Proposition or(@Nonnull Proposition other) {
        if (UNKNOWN == other) {
            return UNKNOWN;
        }
        return Proposition.of(Objects.requireNonNull(this.value) != false || Objects.requireNonNull(other.value) != false);
    }

    @Nonnull
    public static Proposition of(@Nullable Boolean bool) {
        return null == bool ? UNKNOWN : (bool != false ? TRUE : FALSE);
    }

    boolean coalesce() {
        return this == TRUE;
    }
}

