/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Narrowable;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(value=API.Status.EXPERIMENTAL)
public interface QueryPredicate
extends Correlated<QueryPredicate>,
TreeLike<QueryPredicate>,
UsesValueEquivalence<QueryPredicate>,
PlanHashable,
Narrowable<QueryPredicate>,
PlanSerializable {
    @Override
    @Nonnull
    default public QueryPredicate getThis() {
        return this;
    }

    @Nonnull
    default public Optional<PredicateMultiMap.PredicateMapping> impliesCandidatePredicateMaybe(@NonNull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull QueryPredicate candidatePredicate, @Nonnull EvaluationContext evaluationContext) {
        if (candidatePredicate instanceof Placeholder) {
            return Optional.empty();
        }
        if (candidatePredicate.isTautology()) {
            return Optional.of(PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setPredicateCompensation(this.getDefaultPredicateCompensation(originalQueryPredicate)).build());
        }
        ConstrainedBoolean semanticEquals = this.semanticEquals((Object)candidatePredicate, valueEquivalence);
        return semanticEquals.mapToOptional(queryPlanConstraint -> PredicateMultiMap.PredicateMapping.regularMappingBuilder(originalQueryPredicate, this, candidatePredicate).setConstraint((QueryPlanConstraint)queryPlanConstraint).build());
    }

    @Nonnull
    default public PredicateMultiMap.PredicateCompensation getDefaultPredicateCompensation(@Nonnull QueryPredicate originalQueryPredicate) {
        return (partialMatch, boundParameterPrefixMap, pullUp) -> this.computeCompensationFunction(partialMatch, originalQueryPredicate, boundParameterPrefixMap, pullUp);
    }

    @Nonnull
    default public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch partialMatch, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nonnull PullUp pullUp) {
        Debugger.sanityCheck(() -> Verify.verify(Iterables.size(this.getChildren()) == Iterables.size(originalQueryPredicate.getChildren())));
        Iterator originalChildrenIterator = originalQueryPredicate.getChildren().iterator();
        ImmutableList.Builder childPredicateCompensations = ImmutableList.builder();
        for (QueryPredicate childPredicate : this.getChildren()) {
            QueryPredicate originalChildPredicate = (QueryPredicate)originalChildrenIterator.next();
            childPredicateCompensations.add(childPredicate.computeCompensationFunction(partialMatch, originalChildPredicate, boundParameterPrefixMap, pullUp));
        }
        return this.computeCompensationFunction(partialMatch, originalQueryPredicate, boundParameterPrefixMap, (List<PredicateMultiMap.PredicateCompensationFunction>)((Object)childPredicateCompensations.build()), pullUp);
    }

    @Nonnull
    public PredicateMultiMap.PredicateCompensationFunction computeCompensationFunction(@Nonnull PartialMatch var1, @Nonnull QueryPredicate var2, @Nonnull Map<CorrelationIdentifier, ComparisonRange> var3, @Nonnull List<PredicateMultiMap.PredicateCompensationFunction> var4, @Nonnull PullUp var5);

    @Nonnull
    default public QueryPredicate toResidualPredicate() {
        if (Iterables.isEmpty(this.getChildren())) {
            return this;
        }
        return (QueryPredicate)this.withChildren(StreamSupport.stream(this.getChildren().spliterator(), false).map(QueryPredicate::toResidualPredicate).collect(ImmutableList.toImmutableList()));
    }

    default public Collection<PredicateMultiMap.PredicateMapping> findImpliedMappings(@NonNull ValueEquivalence valueEquivalence, @Nonnull QueryPredicate originalQueryPredicate, @Nonnull Iterable<? extends QueryPredicate> candidatePredicates, @Nonnull EvaluationContext evaluationContext) {
        HashSet mappingKeys = Sets.newHashSet();
        ImmutableList.Builder mappingBuilder = ImmutableList.builder();
        for (QueryPredicate queryPredicate : candidatePredicates) {
            Optional<PredicateMultiMap.PredicateMapping> predicateMappingOptional = this.impliesCandidatePredicateMaybe(valueEquivalence, originalQueryPredicate, queryPredicate, evaluationContext);
            predicateMappingOptional.ifPresent(predicateMapping -> {
                PredicateMultiMap.PredicateMapping.MappingKey mappingKey = predicateMapping.getMappingKey();
                if (!mappingKeys.contains(mappingKey)) {
                    mappingKeys.add(mappingKey);
                    mappingBuilder.add(predicateMapping);
                }
            });
        }
        ImmutableCollection result = mappingBuilder.build();
        if (mappingKeys.isEmpty()) {
            ConstantPredicate constantPredicate = new ConstantPredicate((Boolean)true);
            return this.impliesCandidatePredicateMaybe(valueEquivalence, originalQueryPredicate, constantPredicate, evaluationContext).map(ImmutableSet::of).orElseThrow(() -> new RecordCoreException("should have found at least one mapping", new Object[0]));
        }
        return result;
    }

    default public boolean isTautology() {
        return false;
    }

    default public boolean isContradiction() {
        return false;
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="compile-time evaluations take their value from the context only")
    default public Boolean compileTimeEval(@Nonnull EvaluationContext context) {
        return this.eval(null, context);
    }

    @Nullable
    default public <M extends Message> Boolean evalWithoutStore(@Nonnull EvaluationContext context) {
        return this.eval(null, context);
    }

    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2);

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren();

    @Override
    public int semanticHashCode();

    public int hashCodeWithoutChildren();

    @Override
    default public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.semanticEquals(other, ValueEquivalence.fromAliasMap(aliasMap)).isTrue();
    }

    @Override
    @Nonnull
    default public ConstrainedBoolean semanticEqualsTyped(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        ConstrainedBoolean equalsWithoutChildren = this.equalsWithoutChildren(other, valueEquivalence);
        if (equalsWithoutChildren.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        return equalsWithoutChildren.composeWithOther(this.equalsForChildren(other, valueEquivalence));
    }

    @Nonnull
    default public ConstrainedBoolean equalsForChildren(@Nonnull QueryPredicate otherPred, @Nonnull ValueEquivalence valueEquivalence) {
        Iterator preds = this.getChildren().iterator();
        Iterator otherPreds = otherPred.getChildren().iterator();
        ConstrainedBoolean constraint = ConstrainedBoolean.alwaysTrue();
        while (preds.hasNext()) {
            if (!otherPreds.hasNext()) {
                return ConstrainedBoolean.falseValue();
            }
            ConstrainedBoolean semanticEqualsOptional = ((QueryPredicate)preds.next()).semanticEquals(otherPreds.next(), valueEquivalence);
            if (semanticEqualsOptional.isFalse()) {
                return ConstrainedBoolean.falseValue();
            }
            constraint = constraint.composeWithOther(semanticEqualsOptional);
        }
        if (otherPreds.hasNext()) {
            return ConstrainedBoolean.falseValue();
        }
        return constraint;
    }

    @Nonnull
    default public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        if (this == other) {
            return ConstrainedBoolean.alwaysTrue();
        }
        if (other.getClass() != this.getClass()) {
            return ConstrainedBoolean.falseValue();
        }
        return other.isAtomic() == this.isAtomic() ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
    }

    public boolean isAtomic();

    @Nonnull
    public QueryPredicate withAtomicity(boolean var1);

    @Nonnull
    default public ExplainTokensWithPrecedence explain() {
        ImmutableList<Supplier<ExplainTokensWithPrecedence>> explainFunctions = Streams.stream(this.getChildren()).map(child -> child::explain).collect(ImmutableList.toImmutableList());
        return this.explain(explainFunctions);
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> var1);

    @Override
    @Nonnull
    default public QueryPredicate rebase(@Nonnull AliasMap aliasMap) {
        RegularTranslationMap translationMap = TranslationMap.rebaseWithAliasMap(aliasMap);
        return this.translateCorrelations(translationMap, false);
    }

    @Nonnull
    default public QueryPredicate translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplify) {
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        return (QueryPredicate)this.replaceLeavesMaybe(predicate -> predicate.translateLeafPredicate(translationMap, shouldSimplify)).orElseThrow(() -> new RecordCoreException("unable to map tree", new Object[0]));
    }

    @Nullable
    default public QueryPredicate translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplify) {
        throw new RecordCoreException("implementor must override", new Object[0]);
    }

    @Nonnull
    default public Optional<PredicateWithValueAndRanges> toValueWithRangesMaybe(@Nonnull EvaluationContext evaluationContext) {
        return Optional.empty();
    }

    @Nonnull
    default public Optional<QueryPredicate> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
        return this.replaceLeavesMaybe(leafPredicate -> {
            if (leafPredicate instanceof PredicateWithValue) {
                PredicateWithValue predicateWithValue = (PredicateWithValue)leafPredicate;
                return predicateWithValue.translateValueAndComparisonsMaybe(replacementFunction, comparison -> comparison.replaceValuesMaybe(replacementFunction)).orElse(null);
            }
            return leafPredicate;
        });
    }

    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext var1);

    @Nonnull
    public static QueryPredicate fromQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQueryPredicate queryPredicateProto) {
        return (QueryPredicate)PlanSerialization.dispatchFromProtoContainer(serializationContext, queryPredicateProto);
    }

    @Nonnull
    public static List<QueryPredicate> translatePredicates(@Nonnull TranslationMap translationMap, @Nonnull List<QueryPredicate> predicates, boolean shouldSimplifyValues) {
        ImmutableList.Builder resultPredicatesBuilder = ImmutableList.builder();
        for (QueryPredicate predicate : predicates) {
            QueryPredicate newOuterInnerPredicate = (QueryPredicate)predicate.replaceLeavesMaybe(leafPredicate -> leafPredicate.translateLeafPredicate(translationMap, shouldSimplifyValues)).orElseThrow(() -> new RecordCoreException("unable to translate predicate", new Object[0]));
            resultPredicatesBuilder.add(newOuterInnerPredicate);
        }
        return resultPredicatesBuilder.build();
    }
}

