/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.IndexComparison;
import com.apple.foundationdb.record.planprotos.PCompilableRange;
import com.apple.foundationdb.record.planprotos.PRangeConstraints;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Proposition;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RangeConstraints
implements PlanHashable,
Correlated<RangeConstraints>,
UsesValueEquivalence<RangeConstraints>,
PlanSerializable {
    @Nonnull
    private final Supplier<List<Comparisons.Comparison>> comparisonsCalculator;
    @Nonnull
    private final Supplier<Set<CorrelationIdentifier>> correlationsSupplier;
    @Nonnull
    private final Supplier<Boolean> constantValueComparandsChecker;
    @Nullable
    private final CompilableRange evaluableRange;
    @Nonnull
    private final Set<Comparisons.Comparison> deferredRanges;
    @Nonnull
    private static final Range<Boundary> emptyRange = Range.closedOpen(Boundary.from(new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, 0), EvaluationContext.empty()), Boundary.from(new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN, 0), EvaluationContext.empty()));

    private RangeConstraints(@Nullable CompilableRange evaluableRange, @Nonnull Set<Comparisons.Comparison> deferredRanges) {
        this.evaluableRange = evaluableRange;
        this.deferredRanges = ImmutableSet.copyOf(deferredRanges);
        this.comparisonsCalculator = Suppliers.memoize(this::computeComparisons);
        this.correlationsSupplier = Suppliers.memoize(this::computeCorrelations);
        this.constantValueComparandsChecker = Suppliers.memoize(this::checkConstantValueComparands);
    }

    @Nonnull
    private List<Comparisons.Comparison> computeComparisons() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.deferredRanges);
        if (this.evaluableRange != null) {
            result.addAll(this.evaluableRange.compilableComparisons);
        }
        return result.build();
    }

    public boolean isConstraining() {
        return this.evaluableRange != null || !this.deferredRanges.isEmpty();
    }

    @Nonnull
    public List<Comparisons.Comparison> getComparisons() {
        return this.comparisonsCalculator.get();
    }

    @Nonnull
    public Set<Comparisons.Comparison> getDeferredRanges() {
        return this.deferredRanges;
    }

    @Nonnull
    public ComparisonRange asComparisonRange() {
        ComparisonRange resultRange = ComparisonRange.EMPTY;
        for (Comparisons.Comparison comparison : this.getComparisons()) {
            resultRange = resultRange.merge(comparison).getComparisonRange();
        }
        return resultRange;
    }

    @Nonnull
    public RangeConstraints compileTimeEval(@Nonnull EvaluationContext context) {
        if (this.constantValueComparandsChecker.get().booleanValue()) {
            return this;
        }
        Builder builder = RangeConstraints.newBuilder();
        for (Comparisons.Comparison comparison : this.getComparisons()) {
            if (comparison instanceof Comparisons.ValueComparison) {
                Object newComparand = ((Comparisons.ValueComparison)comparison).getComparandValue().evalWithoutStore(context);
                builder.addComparisonMaybe(new Comparisons.SimpleComparison(comparison.getType(), newComparand));
                continue;
            }
            builder.addComparisonMaybe(comparison);
        }
        return builder.build().orElseThrow(() -> new RecordCoreException("could not build compile-time range constraint", new Object[0]));
    }

    public boolean isCompileTime() {
        return this.constantValueComparandsChecker.get();
    }

    @Nonnull
    private Set<CorrelationIdentifier> computeCorrelations() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.deferredRanges.forEach(c -> result.addAll(c.getCorrelatedTo()));
        if (this.evaluableRange != null) {
            this.evaluableRange.compilableComparisons.forEach(c -> result.addAll(c.getCorrelatedTo()));
        }
        return result.build();
    }

    private boolean checkConstantValueComparands() {
        boolean foundConstantValue = false;
        for (Comparisons.Comparison comparison : this.getComparisons()) {
            if (!(comparison instanceof Comparisons.ValueComparison) || !(((Comparisons.ValueComparison)comparison).getComparandValue() instanceof ConstantObjectValue)) continue;
            foundConstantValue = true;
            break;
        }
        return foundConstantValue;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.correlationsSupplier.get();
    }

    public boolean isCompileTimeEvaluable() {
        return this.deferredRanges.isEmpty();
    }

    @Nonnull
    public Proposition isEmpty(@Nonnull EvaluationContext evaluationContext) {
        if (this.deferredRanges.isEmpty()) {
            Range<Boundary> range = Objects.requireNonNull(this.evaluableRange).compile(evaluationContext);
            if (range != null && range.isEmpty()) {
                return Proposition.TRUE;
            }
            return Proposition.FALSE;
        }
        return Proposition.UNKNOWN;
    }

    @Nonnull
    public Proposition encloses(@Nonnull RangeConstraints other, @Nonnull EvaluationContext evaluationContext) {
        if (!this.isCompileTimeEvaluable() || !other.isCompileTimeEvaluable()) {
            return Proposition.UNKNOWN;
        }
        if (this.evaluableRange == null) {
            return Proposition.TRUE;
        }
        if (other.evaluableRange == null) {
            return Proposition.FALSE;
        }
        Range<Boundary> thisRange = this.evaluableRange.compile(evaluationContext);
        if (thisRange == null) {
            return Proposition.TRUE;
        }
        Range<Boundary> otherRange = other.evaluableRange.compile(evaluationContext);
        if (otherRange == null) {
            return Proposition.FALSE;
        }
        if (thisRange.encloses(otherRange)) {
            return Proposition.TRUE;
        }
        return Proposition.FALSE;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.evaluableRange);
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        ExplainTokens resultExplainTokens = new ExplainTokens();
        resultExplainTokens.addOpeningSquareBracket();
        if (this.evaluableRange == null) {
            resultExplainTokens.addOpeningParen().addToString("-\u221e..+\u221e").addClosingParen();
        } else {
            resultExplainTokens.addNested(ExplainTokensWithPrecedence.Precedence.AND.parenthesizeChild(this.evaluableRange.explain()));
        }
        if (!this.deferredRanges.isEmpty()) {
            resultExplainTokens.addSequence(() -> new ExplainTokens().addWhitespace().addKeyword("AND").addWhitespace(), () -> this.deferredRanges.stream().map(Comparisons.Comparison::explain).map(ExplainTokensWithPrecedence.Precedence.AND::parenthesizeChild).iterator());
        }
        resultExplainTokens.addClosingSquareBracket();
        return ExplainTokensWithPrecedence.of(resultExplainTokens);
    }

    @Nonnull
    public String toString() {
        return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeConstraints that = (RangeConstraints)o;
        return Objects.equals(this.evaluableRange, that.evaluableRange) && this.deferredRanges.equals(that.deferredRanges);
    }

    public int hashCode() {
        return Objects.hash(this.evaluableRange, this.deferredRanges);
    }

    @Override
    @Nonnull
    public RangeConstraints rebase(@Nonnull AliasMap translationMap) {
        if (this.evaluableRange == null) {
            if (this.deferredRanges.isEmpty()) {
                return this;
            }
            ImmutableSet<Comparisons.Comparison> newNonCompileTimeComparisons = this.deferredRanges.stream().map(c -> c.rebase(translationMap)).collect(ImmutableSet.toImmutableSet());
            return new RangeConstraints(null, newNonCompileTimeComparisons);
        }
        ImmutableSet<Comparisons.Comparison> newNonCompileTimeComparisons = this.deferredRanges.stream().map(c -> c.rebase(translationMap)).collect(ImmutableSet.toImmutableSet());
        ImmutableSet<Comparisons.Comparison> newCompilableComparisons = this.evaluableRange.compilableComparisons.stream().map(c -> c.rebase(translationMap)).collect(ImmutableSet.toImmutableSet());
        return new RangeConstraints(new CompilableRange(newCompilableComparisons), newNonCompileTimeComparisons);
    }

    /*
     * Unable to fully structure code
     */
    @Nonnull
    public RangeConstraints translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        constraintsBuilder = RangeConstraints.newBuilder();
        allAdded = true;
        if (this.evaluableRange != null) {
            allAdded = this.evaluableRange.compilableComparisons.stream().map((Function<Comparisons.Comparison, Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateCorrelations$8(com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap boolean com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)((TranslationMap)translationMap, (boolean)shouldSimplifyValues)).allMatch((Predicate<Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, addComparisonMaybe(com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Z)((Builder)constraintsBuilder));
        }
        if (!allAdded) ** GOTO lbl-1000
        if (this.deferredRanges.stream().map((Function<Comparisons.Comparison, Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateCorrelations$9(com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap boolean com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)((TranslationMap)translationMap, (boolean)shouldSimplifyValues)).allMatch((Predicate<Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, addComparisonMaybe(com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Z)((Builder)constraintsBuilder))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        allAdded = v0;
        v1 = maybeNewRange = allAdded != false ? constraintsBuilder.build() : Optional.empty();
        if (maybeNewRange.isPresent()) {
            return (RangeConstraints)maybeNewRange.get();
        }
        if (this.evaluableRange == null) {
            if (this.deferredRanges.isEmpty()) {
                return this;
            }
            newNonCompileTimeComparisons = this.deferredRanges.stream().map((Function<Comparisons.Comparison, Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateCorrelations$10(com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap boolean com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)((TranslationMap)translationMap, (boolean)shouldSimplifyValues)).collect(ImmutableSet.toImmutableSet());
            return new RangeConstraints(null, newNonCompileTimeComparisons);
        }
        newNonCompileTimeComparisons = this.deferredRanges.stream().map((Function<Comparisons.Comparison, Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateCorrelations$11(com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap boolean com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)((TranslationMap)translationMap, (boolean)shouldSimplifyValues)).collect(ImmutableSet.toImmutableSet());
        newCompilableComparisons = this.evaluableRange.compilableComparisons.stream().map((Function<Comparisons.Comparison, Comparisons.Comparison>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$translateCorrelations$12(com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap boolean com.apple.foundationdb.record.query.expressions.Comparisons$Comparison ), (Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)Lcom/apple/foundationdb/record/query/expressions/Comparisons$Comparison;)((TranslationMap)translationMap, (boolean)shouldSimplifyValues)).collect(ImmutableSet.toImmutableSet());
        return new RangeConstraints(new CompilableRange(newCompilableComparisons), newNonCompileTimeComparisons);
    }

    @Nonnull
    public Optional<RangeConstraints> translateRanges(@Nonnull Function<Comparisons.Comparison, Optional<Comparisons.Comparison>> comparisonTranslator) {
        Builder constraintsBuilder = RangeConstraints.newBuilder();
        boolean allAdded = true;
        AtomicBoolean allSame = new AtomicBoolean(true);
        if (this.evaluableRange != null) {
            allAdded = this.evaluableRange.compilableComparisons.stream().map(compilableComparison -> {
                Optional newCompilableComparison = (Optional)comparisonTranslator.apply((Comparisons.Comparison)compilableComparison);
                if (newCompilableComparison.isPresent() && newCompilableComparison.get() != compilableComparison) {
                    allSame.set(false);
                }
                return newCompilableComparison;
            }).map(maybeComparison -> maybeComparison.map(constraintsBuilder::addComparisonMaybe)).allMatch(maybeAdded -> maybeAdded.orElse(false));
        }
        boolean bl = allAdded = allAdded && this.deferredRanges.stream().map(compilableComparison -> {
            Optional newCompilableComparison = (Optional)comparisonTranslator.apply((Comparisons.Comparison)compilableComparison);
            if (newCompilableComparison.isPresent() && newCompilableComparison.get() != compilableComparison) {
                allSame.set(false);
            }
            return newCompilableComparison;
        }).map(maybeComparison -> maybeComparison.map(constraintsBuilder::addComparisonMaybe)).allMatch(maybeAdded -> maybeAdded.orElse(false));
        if (allAdded) {
            return allSame.get() ? Optional.of(this) : constraintsBuilder.build();
        }
        return Optional.empty();
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.semanticEquals(other, ValueEquivalence.fromAliasMap(aliasMap)).isTrue();
    }

    @Override
    @Nonnull
    public ConstrainedBoolean semanticEqualsTyped(@Nonnull RangeConstraints other, @Nonnull ValueEquivalence valueEquivalence) {
        if (this.deferredRanges.size() != other.deferredRanges.size()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean deferredRangesEquals = valueEquivalence.semanticEquals(this.deferredRanges, other.deferredRanges);
        if (deferredRangesEquals.isFalse()) {
            return ConstrainedBoolean.falseValue();
        }
        if (this.evaluableRange == null && other.evaluableRange == null) {
            return deferredRangesEquals;
        }
        return deferredRangesEquals.compose(ignored -> {
            if (this.evaluableRange != null && other.evaluableRange != null) {
                return valueEquivalence.semanticEquals(this.evaluableRange.compilableComparisons, other.evaluableRange.compilableComparisons);
            }
            return ConstrainedBoolean.falseValue();
        });
    }

    @Override
    public int semanticHashCode() {
        return Objects.hash(this.evaluableRange, this.deferredRanges);
    }

    @Override
    @Nonnull
    public PRangeConstraints toProto(@Nonnull PlanSerializationContext serializationContext) {
        PRangeConstraints.Builder builder = PRangeConstraints.newBuilder();
        if (this.evaluableRange != null) {
            builder.setEvaluableRange(this.evaluableRange.toProto(serializationContext));
        }
        for (Comparisons.Comparison deferredRange : this.deferredRanges) {
            builder.addDeferredRanges(deferredRange.toComparisonProto(serializationContext));
        }
        return builder.build();
    }

    @Nonnull
    public static RangeConstraints fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRangeConstraints rangeConstraintsProto) {
        ImmutableSet.Builder deferredRangesBuilder = ImmutableSet.builder();
        for (int i = 0; i < rangeConstraintsProto.getDeferredRangesCount(); ++i) {
            deferredRangesBuilder.add(Comparisons.Comparison.fromComparisonProto(serializationContext, rangeConstraintsProto.getDeferredRanges(i)));
        }
        return new RangeConstraints(rangeConstraintsProto.hasEvaluableRange() ? CompilableRange.fromProto(serializationContext, rangeConstraintsProto.getEvaluableRange()) : null, (Set<Comparisons.Comparison>)((Object)deferredRangesBuilder.build()));
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static RangeConstraints emptyRange() {
        return Builder.emptyRange;
    }

    private static /* synthetic */ Comparisons.Comparison lambda$translateCorrelations$12(TranslationMap translationMap, boolean shouldSimplifyValues, Comparisons.Comparison c) {
        return c.translateCorrelations(translationMap, shouldSimplifyValues);
    }

    private static /* synthetic */ Comparisons.Comparison lambda$translateCorrelations$11(TranslationMap translationMap, boolean shouldSimplifyValues, Comparisons.Comparison c) {
        return c.translateCorrelations(translationMap, shouldSimplifyValues);
    }

    private static /* synthetic */ Comparisons.Comparison lambda$translateCorrelations$10(TranslationMap translationMap, boolean shouldSimplifyValues, Comparisons.Comparison c) {
        return c.translateCorrelations(translationMap, shouldSimplifyValues);
    }

    private static /* synthetic */ Comparisons.Comparison lambda$translateCorrelations$9(TranslationMap translationMap, boolean shouldSimplifyValues, Comparisons.Comparison c) {
        return c.translateCorrelations(translationMap, shouldSimplifyValues);
    }

    private static /* synthetic */ Comparisons.Comparison lambda$translateCorrelations$8(TranslationMap translationMap, boolean shouldSimplifyValues, Comparisons.Comparison c) {
        return c.translateCorrelations(translationMap, shouldSimplifyValues);
    }

    public static class CompilableRange
    implements PlanHashable,
    PlanSerializable {
        @Nonnull
        private final Set<Comparisons.Comparison> compilableComparisons;

        public CompilableRange(@Nonnull Set<Comparisons.Comparison> compilableComparisons) {
            this.compilableComparisons = compilableComparisons;
        }

        public void intersect(@Nullable CompilableRange other) {
            if (other == null) {
                return;
            }
            this.compilableComparisons.addAll(other.compilableComparisons);
        }

        @Nullable
        public Range<Boundary> compile(@Nonnull EvaluationContext evaluationContext) {
            Range<Boundary> range = null;
            for (Comparisons.Comparison comparison : this.compilableComparisons) {
                Range<Boundary> comparisonRange = CompilableRange.toRange(comparison, evaluationContext);
                if (range == null) {
                    range = comparisonRange;
                    continue;
                }
                if (range.isConnected(comparisonRange)) {
                    range = range.intersection(comparisonRange);
                    continue;
                }
                return emptyRange;
            }
            return range;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return PlanHashable.objectPlanHash(mode, this.compilableComparisons);
        }

        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> this.compilableComparisons.stream().map(compilableComparison -> compilableComparison.explain().getExplainTokens()).iterator()));
        }

        @Nonnull
        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Nonnull
        private static Range<Boundary> toRange(@Nonnull Comparisons.Comparison comparison, @Nonnull EvaluationContext evaluationContext) {
            Boundary boundary = Boundary.from(comparison, evaluationContext);
            switch (comparison.getType()) {
                case GREATER_THAN: 
                case NOT_NULL: {
                    return Range.greaterThan(boundary);
                }
                case GREATER_THAN_OR_EQUALS: {
                    return Range.atLeast(boundary);
                }
                case LESS_THAN: {
                    return Range.lessThan(boundary);
                }
                case LESS_THAN_OR_EQUALS: {
                    return Range.atMost(boundary);
                }
                case EQUALS: 
                case IS_NULL: {
                    return Range.singleton(boundary);
                }
            }
            throw new RecordCoreException("cannot transform comparison to range", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_VALUE, comparison});
        }

        @Nonnull
        public Optional<CompilableRange> translateRange(@Nonnull Function<Comparisons.Comparison, Optional<Comparisons.Comparison>> comparisonTranslator) {
            ImmutableSet.Builder newCompilableComparisonsBuilder = ImmutableSet.builder();
            for (Comparisons.Comparison compilableComparison : this.compilableComparisons) {
                Optional<Comparisons.Comparison> newCompilableComparisonOptional = comparisonTranslator.apply(compilableComparison);
                if (newCompilableComparisonOptional.isEmpty()) {
                    return Optional.empty();
                }
                newCompilableComparisonsBuilder.add(newCompilableComparisonOptional.get());
            }
            return Optional.of(new CompilableRange((Set<Comparisons.Comparison>)((Object)newCompilableComparisonsBuilder.build())));
        }

        @Override
        @Nonnull
        public PCompilableRange toProto(@Nonnull PlanSerializationContext serializationContext) {
            PCompilableRange.Builder builder = PCompilableRange.newBuilder();
            for (Comparisons.Comparison compilableComparison : this.compilableComparisons) {
                builder.addCompilableComparisons(compilableComparison.toComparisonProto(serializationContext));
            }
            return builder.build();
        }

        @Nonnull
        public static CompilableRange fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PCompilableRange compilableRangeProto) {
            ImmutableSet.Builder compilableComparisonsBuilder = ImmutableSet.builder();
            for (int i = 0; i < compilableRangeProto.getCompilableComparisonsCount(); ++i) {
                compilableComparisonsBuilder.add(Comparisons.Comparison.fromComparisonProto(serializationContext, compilableRangeProto.getCompilableComparisons(i)));
            }
            return new CompilableRange((Set<Comparisons.Comparison>)((Object)compilableComparisonsBuilder.build()));
        }
    }

    public static class Builder {
        @Nonnull
        private ImmutableSet.Builder<Comparisons.Comparison> compilableComparisons = ImmutableSet.builder();
        @Nonnull
        private ImmutableSet.Builder<Comparisons.Comparison> nonCompilableComparisons = ImmutableSet.builder();
        @Nonnull
        private static final Set<Comparisons.Type> allowedComparisonTypes = new LinkedHashSet<Comparisons.Type>();
        @Nonnull
        private static final RangeConstraints emptyRange = new RangeConstraints(new CompilableRange(Set.of(new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, 0), new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN, 0))), Set.of());

        @Nonnull
        private static Set<Comparisons.Comparison> intersect(@Nonnull Set<Comparisons.Comparison> left, @Nonnull Set<Comparisons.Comparison> right) {
            ImmutableSet.Builder newNonCompileTimeComparisons = ImmutableSet.builder();
            newNonCompileTimeComparisons.addAll(left);
            newNonCompileTimeComparisons.addAll(right);
            return newNonCompileTimeComparisons.build();
        }

        private Builder() {
        }

        private boolean isCompileTime(@Nonnull Comparisons.Comparison comparison) {
            return IndexComparison.isSupported(comparison) && allowedComparisonTypes.contains((Object)comparison.getType());
        }

        private boolean canBeUsedInScanPrefix(@Nonnull Comparisons.Comparison comparison) {
            switch (comparison.getType()) {
                case GREATER_THAN: 
                case NOT_NULL: 
                case GREATER_THAN_OR_EQUALS: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUALS: 
                case EQUALS: 
                case IS_NULL: 
                case STARTS_WITH: 
                case NOT_DISTINCT_FROM: 
                case IS_DISTINCT_FROM: {
                    return true;
                }
                case TEXT_CONTAINS_ALL: 
                case TEXT_CONTAINS_ALL_WITHIN: 
                case TEXT_CONTAINS_ANY: 
                case TEXT_CONTAINS_PHRASE: 
                case TEXT_CONTAINS_PREFIX: 
                case TEXT_CONTAINS_ALL_PREFIXES: 
                case TEXT_CONTAINS_ANY_PREFIX: 
                case IN: 
                case NOT_EQUALS: 
                case SORT: 
                case LIKE: {
                    return false;
                }
            }
            throw new RecordCoreException("unexpected comparison type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, comparison.getType()});
        }

        public boolean addComparisonMaybe(@Nonnull Comparisons.Comparison comparison) {
            if (!this.canBeUsedInScanPrefix(comparison)) {
                return false;
            }
            if (this.isCompileTime(comparison)) {
                this.compilableComparisons.add((Object)comparison);
            } else {
                this.nonCompilableComparisons.add((Object)comparison);
            }
            return true;
        }

        public void add(@Nonnull RangeConstraints rangeConstraints) {
            if (rangeConstraints.evaluableRange != null) {
                this.compilableComparisons = ImmutableSet.builder().addAll(Builder.intersect((Set<Comparisons.Comparison>)((Object)this.compilableComparisons.build()), rangeConstraints.evaluableRange.compilableComparisons));
            }
            this.nonCompilableComparisons = ImmutableSet.builder().addAll(Builder.intersect((Set<Comparisons.Comparison>)((Object)this.nonCompilableComparisons.build()), rangeConstraints.deferredRanges));
        }

        @Nonnull
        public Optional<RangeConstraints> build() {
            ImmutableCollection compilableComparisonsList = this.compilableComparisons.build();
            ImmutableCollection nonCompilableComparisonsList = this.nonCompilableComparisons.build();
            if (compilableComparisonsList.isEmpty() && nonCompilableComparisonsList.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new RangeConstraints(new CompilableRange((Set<Comparisons.Comparison>)((Object)compilableComparisonsList)), (Set<Comparisons.Comparison>)((Object)nonCompilableComparisonsList)));
        }

        static {
            allowedComparisonTypes.add(Comparisons.Type.GREATER_THAN);
            allowedComparisonTypes.add(Comparisons.Type.GREATER_THAN_OR_EQUALS);
            allowedComparisonTypes.add(Comparisons.Type.LESS_THAN);
            allowedComparisonTypes.add(Comparisons.Type.LESS_THAN_OR_EQUALS);
            allowedComparisonTypes.add(Comparisons.Type.EQUALS);
            allowedComparisonTypes.add(Comparisons.Type.IS_NULL);
            allowedComparisonTypes.add(Comparisons.Type.NOT_NULL);
        }
    }

    static class Boundary
    implements Comparable<Boundary> {
        @Nonnull
        private final Tuple tuple;
        @Nonnull
        private final Comparisons.Comparison comparison;

        private Boundary(@Nonnull Tuple tuple, @Nonnull Comparisons.Comparison comparison) {
            this.tuple = tuple;
            this.comparison = comparison;
        }

        @Override
        public int compareTo(Boundary other) {
            return this.tuple.compareTo(other.tuple);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Boundary boundary = (Boundary)o;
            return this.tuple.equals(boundary.tuple);
        }

        public int hashCode() {
            return Objects.hash(this.tuple);
        }

        public String toString() {
            return this.comparison.getComparand() == null ? "<NULL>" : this.comparison.getComparand().toString();
        }

        @Nonnull
        private static Boundary from(@Nonnull Comparisons.Comparison comparison, @Nonnull EvaluationContext evaluationContext) {
            return Boundary.from(Boundary.toTuple(comparison, evaluationContext), comparison);
        }

        @Nonnull
        private static Boundary from(@Nonnull Tuple tuple, @Nonnull Comparisons.Comparison comparison) {
            return new Boundary(tuple, comparison);
        }

        @Nonnull
        private static Tuple toTuple(@Nonnull Comparisons.Comparison comparison, @Nonnull EvaluationContext evaluationContext) {
            ArrayList<Object> items = new ArrayList<Object>();
            Object comparand = comparison.getComparand(null, evaluationContext);
            if (comparison.hasMultiColumnComparand()) {
                items.addAll(((Tuple)comparand).getItems());
            } else {
                items.add(ScanComparisons.toTupleItem(comparand));
            }
            return Tuple.fromList(items);
        }
    }
}

