/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.predicates;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PQueryPredicate;
import com.apple.foundationdb.record.planprotos.PValuePredicate;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AbstractQueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ValuePredicate
extends AbstractQueryPredicate
implements PredicateWithValue,
PredicateWithComparisons {
    @Nonnull
    private final Value value;
    @Nonnull
    private final Comparisons.Comparison comparison;

    private ValuePredicate(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValuePredicate valuePredicate) {
        super(serializationContext, Objects.requireNonNull(valuePredicate.getSuper()));
        this.value = Value.fromValueProto(serializationContext, Objects.requireNonNull(valuePredicate.getValue()));
        this.comparison = Comparisons.Comparison.fromComparisonProto(serializationContext, Objects.requireNonNull(valuePredicate.getComparison()));
    }

    public ValuePredicate(@Nonnull Value value, @Nonnull Comparisons.Comparison comparison) {
        super(false);
        this.value = value;
        this.comparison = comparison;
    }

    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    @Nonnull
    public List<Comparisons.Comparison> getComparisons() {
        return ImmutableList.of(this.getComparison());
    }

    @Nonnull
    public Optional<PredicateWithValue> translateValueAndComparisonsMaybe(@Nonnull Function<Value, Optional<Value>> valueTranslator, @Nonnull Function<Comparisons.Comparison, Optional<Comparisons.Comparison>> comparisonTranslator) {
        Optional<Value> newValueOptional = Verify.verifyNotNull(valueTranslator.apply(this.getValue()));
        if (newValueOptional.isEmpty()) {
            return Optional.empty();
        }
        Value newValue = newValueOptional.get();
        return comparisonTranslator.apply(this.comparison).flatMap(newComparison -> {
            if (newValue == this.value && newComparison == this.comparison) {
                return Optional.of(this);
            }
            return Optional.of(new ValuePredicate(newValue, (Comparisons.Comparison)newComparison));
        });
    }

    @Override
    @Nonnull
    public Value getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public ValuePredicate withValue(@Nonnull Value value) {
        return new ValuePredicate(value, this.comparison);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean eval(@Nullable FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context) {
        return this.comparison.eval(store, context, this.value.eval(store, context));
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.value.getCorrelatedTo());
        builder.addAll(this.comparison.getCorrelatedTo());
        return builder.build();
    }

    @Override
    @Nonnull
    public QueryPredicate translateLeafPredicate(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        Value translatedValue = this.value.translateCorrelations(translationMap, shouldSimplifyValues);
        Comparisons.Comparison newComparison = this.comparison.getCorrelatedTo().stream().anyMatch(translationMap::containsSourceAlias) ? this.comparison.translateCorrelations(translationMap, shouldSimplifyValues) : this.comparison;
        if (this.value != translatedValue || newComparison != this.comparison) {
            return new ValuePredicate(translatedValue, newComparison);
        }
        return this;
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeSemanticHashCode() {
        return PredicateWithValue.super.computeSemanticHashCode();
    }

    @Override
    public int hashCodeWithoutChildren() {
        return Objects.hash(this.value.semanticHashCode(), this.comparison.semanticHashCode());
    }

    @Override
    @Nonnull
    public ConstrainedBoolean equalsWithoutChildren(@Nonnull QueryPredicate other, @Nonnull ValueEquivalence valueEquivalence) {
        return PredicateWithValue.super.equalsWithoutChildren(other, valueEquivalence).compose(ignored -> {
            ValuePredicate that = (ValuePredicate)other;
            return this.value.semanticEquals((Object)that.value, valueEquivalence);
        }).compose(ignored -> {
            ValuePredicate that = (ValuePredicate)other;
            return this.comparison.semanticEquals((Object)that.comparison, valueEquivalence);
        });
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash(mode, this.value, this.comparison);
    }

    @Override
    @Nonnull
    public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
        Verify.verify(Iterables.isEmpty(explainSuppliers));
        return ExplainTokensWithPrecedence.of(ExplainTokensWithPrecedence.Precedence.COMPARISONS, ExplainTokensWithPrecedence.Precedence.COMPARISONS.parenthesizeChild(this.value.explain()).addWhitespace().addNested(ExplainTokensWithPrecedence.Precedence.COMPARISONS.parenthesizeChild(this.comparison.explain())));
    }

    @Override
    @Nonnull
    public PValuePredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PValuePredicate.newBuilder().setSuper(this.toAbstractQueryPredicateProto(serializationContext)).setValue(this.value.toValueProto(serializationContext)).setComparison(this.comparison.toComparisonProto(serializationContext)).build();
    }

    @Override
    @Nonnull
    public PQueryPredicate toQueryPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPredicate.newBuilder().setValuePredicate(this.toProto(serializationContext)).build();
    }

    @Nonnull
    public static ValuePredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValuePredicate valuePredicateProto) {
        return new ValuePredicate(serializationContext, valuePredicateProto);
    }

    public static class Deserializer
    implements PlanDeserializer<PValuePredicate, ValuePredicate> {
        @Override
        @Nonnull
        public Class<PValuePredicate> getProtoMessageClass() {
            return PValuePredicate.class;
        }

        @Override
        @Nonnull
        public ValuePredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValuePredicate valuePredicateProto) {
            return ValuePredicate.fromProto(serializationContext, valuePredicateProto);
        }
    }
}

